/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport;

import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.phalanx.wire.Voice;
import org.smallmind.phalanx.wire.signal.ResultSignal;
import org.smallmind.phalanx.wire.signal.Route;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.transport.AsynchronousTransmissionCallback;
import org.smallmind.phalanx.wire.transport.RequestTransport;
import org.smallmind.phalanx.wire.transport.SynchronousTransmissionCallback;
import org.smallmind.phalanx.wire.transport.TransmissionCallback;

public abstract class AbstractRequestTransport
implements RequestTransport {
    private final ConcurrentHashMap<String, TransmissionCallback> callbackMap;
    private final long defaultTimeoutSeconds;

    public AbstractRequestTransport(long defaultTimeoutSeconds) {
        this.defaultTimeoutSeconds = defaultTimeoutSeconds;
        this.callbackMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object acquireResult(SignalCodec signalCodec, Route route, Voice<?, ?> voice, String messageId, boolean inOnly) throws Throwable {
        if (!inOnly) {
            AsynchronousTransmissionCallback asynchronousCallback = new AsynchronousTransmissionCallback(route.getService(), route.getFunction().getName());
            SynchronousTransmissionCallback previousCallback = (SynchronousTransmissionCallback)this.callbackMap.putIfAbsent(messageId, asynchronousCallback);
            if (previousCallback != null) {
                return previousCallback.getResult(signalCodec, 0L);
            }
            try {
                Object timeoutObject = voice.getConversation().getTimeout();
                long timeoutSeconds = timeoutObject == null || (Long)timeoutObject <= 0L ? this.defaultTimeoutSeconds : (Long)timeoutObject;
                Object object = asynchronousCallback.getResult(signalCodec, timeoutSeconds);
                return object;
            }
            finally {
                this.callbackMap.remove(messageId);
            }
        }
        return null;
    }

    @Override
    public void completeCallback(String correlationId, ResultSignal resultSignal) {
        TransmissionCallback previousCallback = this.callbackMap.get(correlationId);
        if (previousCallback == null) {
            previousCallback = this.callbackMap.putIfAbsent(correlationId, new SynchronousTransmissionCallback(resultSignal));
            if (previousCallback != null && previousCallback instanceof AsynchronousTransmissionCallback) {
                ((AsynchronousTransmissionCallback)previousCallback).setResultSignal(resultSignal);
            }
        } else if (previousCallback instanceof AsynchronousTransmissionCallback) {
            ((AsynchronousTransmissionCallback)previousCallback).setResultSignal(resultSignal);
        }
    }
}

