/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.mock;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.phalanx.wire.transport.mock.MockMessage;
import org.smallmind.phalanx.wire.transport.mock.MockMessageListener;
import org.smallmind.scribe.pen.LoggerManager;

public class MockQueue {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final QueueWorker worker;
    private final ConcurrentLinkedQueue<MockMessage> messageQueue = new ConcurrentLinkedQueue();
    private final ArrayList<MockMessageListener> listenerList = new ArrayList();
    private int listenerIndex = 0;

    public MockQueue() {
        this.worker = new QueueWorker();
        Thread thread = new Thread(this.worker);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MockMessageListener listener) {
        ArrayList<MockMessageListener> arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MockMessageListener listener) {
        ArrayList<MockMessageListener> arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.remove(listener);
        }
    }

    public void play() {
        this.active.set(true);
    }

    public void pause() {
        this.active.set(false);
    }

    public void send(MockMessage message) {
        this.messageQueue.add(message);
    }

    private class QueueWorker
    implements Runnable {
        private QueueWorker() {
        }

        public void close() {
            MockQueue.this.closed.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!MockQueue.this.closed.get()) {
                if (!MockQueue.this.active.get()) continue;
                MockMessage message = MockQueue.this.messageQueue.poll();
                if (message != null) {
                    ArrayList<MockMessageListener> arrayList = MockQueue.this.listenerList;
                    synchronized (arrayList) {
                        if (MockQueue.this.listenerIndex >= MockQueue.this.listenerList.size()) {
                            MockQueue.this.listenerIndex = 0;
                        }
                        MockQueue.this.listenerList.get(MockQueue.this.listenerIndex++).handle(message);
                        continue;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(MockQueue.class).error((Throwable)interruptedException);
                }
            }
        }
    }
}

