/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.phalanx.wire.Methodology;
import org.smallmind.phalanx.wire.MismatchedArgumentException;
import org.smallmind.phalanx.wire.TransportException;
import org.smallmind.phalanx.wire.Wire;
import org.smallmind.phalanx.wire.WireAdapter;
import org.smallmind.phalanx.wire.signal.Function;
import org.smallmind.phalanx.wire.signal.InvocationSignal;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.transport.ArgumentInfo;

public class ArgumentRectifier {
    private static final ConcurrentHashMap<Class<? extends WireAdapter<?, ?>>, WireAdapter<?, ?>> ADAPTER_INSTANCE_MAP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WireAdapter<?, ?> getAdapter(Class<? extends WireAdapter<?, ?>> adapterClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        WireAdapter<?, ?> adapter = ADAPTER_INSTANCE_MAP.get(adapterClass);
        if (adapter == null) {
            ConcurrentHashMap<Class<? extends WireAdapter<?, ?>>, WireAdapter<?, ?>> concurrentHashMap = ADAPTER_INSTANCE_MAP;
            synchronized (concurrentHashMap) {
                adapter = ADAPTER_INSTANCE_MAP.get(adapterClass);
                if (adapter == null) {
                    adapter = adapterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    ADAPTER_INSTANCE_MAP.put(adapterClass, adapter);
                }
            }
        }
        return adapter;
    }

    private static Object marshal(WireAdapter adapter, Object boundObj) throws Exception {
        return adapter.marshal(boundObj);
    }

    private static Object unmarshal(WireAdapter adapter, Object valueObj) throws Exception {
        return adapter.unmarshal(valueObj);
    }

    public static HashMap<String, Object> induceMap(String[] argumentNames, Object[] args) throws TransportException {
        if (args == null || args.length == 0) {
            return null;
        }
        HashMap<String, Object> argumentMap = new HashMap<String, Object>();
        for (int index = 0; index < args.length; ++index) {
            if (args[index] == null) {
                argumentMap.put(argumentNames[index], null);
                continue;
            }
            Class<?> argumentClass = args[index].getClass();
            Wire wire = argumentClass.getAnnotation(Wire.class);
            if (wire != null) {
                try {
                    WireAdapter<?, ?> adapter = ArgumentRectifier.getAdapter(wire.adapter());
                    if (!Serializable.class.isAssignableFrom(adapter.getValueType())) {
                        throw new TransportException("The argument(index=%d, name=%s, class=%s) is not Serializable", index, argumentNames[index], adapter.getValueType().getName());
                    }
                    argumentMap.put(argumentNames[index], ArgumentRectifier.marshal(ArgumentRectifier.getAdapter(wire.adapter()), args[index]));
                    continue;
                }
                catch (Exception exception) {
                    throw new TransportException(exception);
                }
            }
            if (!Serializable.class.isAssignableFrom(argumentClass)) {
                throw new TransportException("The argument(index=%d, name=%s, class=%s) is not Serializable", index, argumentNames[index], args[index].getClass().getName());
            }
            argumentMap.put(argumentNames[index], args[index]);
        }
        return argumentMap;
    }

    public static Object[] constructArray(SignalCodec signalCodec, InvocationSignal invocationSignal, Function invocationFunction, Methodology methodology) throws TransportException {
        Object[] arguments = new Object[invocationFunction.getSignature().length];
        if (invocationSignal.getArguments() != null) {
            for (Map.Entry<String, Object> argumentEntry : invocationSignal.getArguments().entrySet()) {
                ArgumentInfo argumentInfo = methodology.getArgumentInfo(argumentEntry.getKey());
                if (argumentInfo == null) {
                    throw new MismatchedArgumentException("Invocation argument(%s) on method(%s) of service(%s) can't be matched by name", argumentEntry.getKey(), invocationFunction.getName(), invocationSignal.getRoute().getService());
                }
                if (argumentInfo.getIndex() >= arguments.length) {
                    throw new MismatchedArgumentException("Invocation argument(%s) on method(%s) of service(%s) maps to a non-existent argument index(%d)", argumentEntry.getKey(), invocationFunction.getName(), invocationSignal.getRoute().getService(), argumentInfo.getIndex());
                }
                if (argumentEntry.getValue() == null) continue;
                Wire wire = argumentInfo.getParameterType().getAnnotation(Wire.class);
                if (wire != null) {
                    try {
                        WireAdapter<?, ?> adapter = ArgumentRectifier.getAdapter(wire.adapter());
                        arguments[argumentInfo.getIndex()] = ArgumentRectifier.unmarshal(adapter, signalCodec.extractObject(argumentEntry.getValue(), adapter.getValueType()));
                        continue;
                    }
                    catch (Exception exception) {
                        throw new TransportException(exception);
                    }
                }
                arguments[argumentInfo.getIndex()] = signalCodec.extractObject(argumentEntry.getValue(), argumentInfo.getParameterType());
            }
        }
        return arguments;
    }
}

