/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.signal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.smallmind.phalanx.wire.signal.Signal;
import org.smallmind.phalanx.wire.signal.SignalCodec;

public class JavaSerializationSignalCodec
implements SignalCodec {
    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public byte[] encode(Signal signal) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                objectOutputStream.writeObject(signal);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public <S extends Signal> S decode(byte[] buffer, int offset, int len, Class<S> signalClass) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer, offset, len);){
            Signal signal;
            try (ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
                signal = (Signal)signalClass.cast(objectInputStream.readObject());
            }
            return (S)signal;
        }
    }

    @Override
    public <T> T extractObject(Object value, Class<T> clazz) {
        return clazz.cast(value);
    }
}

