/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.amqp.rabbitmq.spring;

import java.util.LinkedList;
import org.smallmind.nutsnbolts.util.Spread;
import org.smallmind.nutsnbolts.util.SpreadParserException;
import org.smallmind.phalanx.wire.transport.amqp.rabbitmq.spring.RabbitMQServer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class RabbitMQServerFactoryBean
implements FactoryBean<RabbitMQServer[]>,
InitializingBean {
    private RabbitMQServer[] serverArray;
    private String serverPattern;
    private String serverSpread;

    public void setServerPattern(String serverPattern) {
        this.serverPattern = serverPattern;
    }

    public void setServerSpread(String serverSpread) {
        this.serverSpread = serverSpread;
    }

    public void afterPropertiesSet() throws SpreadParserException {
        if (this.serverPattern != null && this.serverPattern.length() > 0) {
            LinkedList<RabbitMQServer> serverList = new LinkedList<RabbitMQServer>();
            int colonPos = this.serverPattern.indexOf(58);
            int poundPos = this.serverPattern.indexOf(35);
            if (poundPos < 0) {
                if (colonPos >= 0) {
                    serverList.add(new RabbitMQServer(this.serverPattern.substring(0, colonPos), Integer.parseInt(this.serverPattern.substring(colonPos + 1))));
                } else {
                    serverList.add(new RabbitMQServer(this.serverPattern, 5672));
                }
            } else {
                for (String serverDesignator : Spread.calculate((String)this.serverSpread)) {
                    if (colonPos >= 0) {
                        serverList.add(new RabbitMQServer(this.serverPattern.substring(0, poundPos) + serverDesignator + this.serverPattern.substring(poundPos + 1, colonPos), Integer.parseInt(this.serverPattern.substring(colonPos + 1))));
                        continue;
                    }
                    serverList.add(new RabbitMQServer(this.serverPattern.substring(0, poundPos) + serverDesignator + this.serverPattern.substring(poundPos + 1), 5672));
                }
            }
            this.serverArray = new RabbitMQServer[serverList.size()];
            serverList.toArray(this.serverArray);
        }
    }

    public RabbitMQServer[] getObject() {
        return this.serverArray;
    }

    public Class<?> getObjectType() {
        return RabbitMQServer[].class;
    }

    public boolean isSingleton() {
        return true;
    }
}

