/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.jms;

import javax.jms.JMSException;
import javax.jms.MessageProducer;
import org.smallmind.phalanx.wire.transport.jms.AcknowledgeMode;
import org.smallmind.phalanx.wire.transport.jms.DeliveryMode;
import org.smallmind.phalanx.wire.transport.jms.JmsAcknowledgeMode;

public class MessagePolicy {
    private AcknowledgeMode acknowledgeMode = JmsAcknowledgeMode.AUTO_ACKNOWLEDGE;
    private DeliveryMode deliveryMode = DeliveryMode.NON_PERSISTENT;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int timeToLiveSeconds = 0;
    private int priority = 4;

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setDeliveryMode(DeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setDisableMessageID(boolean disableMessageID) {
        this.disableMessageID = disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public void setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void apply(MessageProducer producer) throws JMSException {
        producer.setDeliveryMode(this.deliveryMode.getJmsValue());
        producer.setDisableMessageID(this.disableMessageID);
        producer.setDisableMessageTimestamp(this.disableMessageTimestamp);
        producer.setTimeToLive((long)(this.timeToLiveSeconds * 1000));
        producer.setPriority(this.priority);
    }
}

