/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.jms;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.LazyBuilder;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.phalanx.wire.transport.ClaxonTag;
import org.smallmind.phalanx.wire.transport.WireProperty;
import org.smallmind.phalanx.wire.transport.jms.ConnectionManager;
import org.smallmind.phalanx.wire.transport.jms.JmsResponseTransport;
import org.smallmind.phalanx.wire.transport.jms.QueueOperator;
import org.smallmind.phalanx.wire.transport.jms.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class RequestListener
implements SessionEmployer,
MessageListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final JmsResponseTransport jmsResponseTransport;
    private final ConnectionManager requestConnectionManager;
    private final Destination requestDestination;
    private final String selector;

    public RequestListener(JmsResponseTransport jmsResponseTransport, ConnectionManager requestConnectionManager, Destination requestDestination, String serviceGroup, String instanceId) throws JMSException {
        this.jmsResponseTransport = jmsResponseTransport;
        this.requestConnectionManager = requestConnectionManager;
        this.requestDestination = requestDestination;
        this.selector = instanceId == null ? WireProperty.SERVICE_GROUP.getKey() + "='" + serviceGroup + "'" : WireProperty.SERVICE_GROUP.getKey() + "='" + serviceGroup + "' AND " + WireProperty.INSTANCE_ID.getKey() + "='" + instanceId + "'";
        requestConnectionManager.createConsumer(this);
    }

    @Override
    public Destination getDestination() {
        return this.requestDestination;
    }

    @Override
    public String getMessageSelector() {
        return this.selector;
    }

    public void play() throws JMSException {
        this.requestConnectionManager.start();
    }

    public void pause() throws JMSException {
        this.requestConnectionManager.stop();
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.requestConnectionManager.stop();
            this.requestConnectionManager.close();
        }
    }

    public void onMessage(Message message) {
        try {
            long timeInQueue = System.currentTimeMillis() - message.getLongProperty(WireProperty.CLOCK.getKey());
            LoggerManager.getLogger(QueueOperator.class).debug("request message received(%s) in %d ms...", new Object[]{message.getJMSMessageID(), timeInQueue});
            Instrument.with(RequestListener.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("queue", ClaxonTag.REQUEST_TRANSIT_TIME.getDisplay())}).update(timeInQueue >= 0L ? timeInQueue : 0L, TimeUnit.MILLISECONDS);
            this.jmsResponseTransport.execute(message);
        }
        catch (Throwable throwable) {
            LoggerManager.getLogger(RequestListener.class).error(throwable);
        }
    }
}

