/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.worker;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.LazyBuilder;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.phalanx.worker.ClaxonTag;
import org.smallmind.phalanx.worker.WorkQueue;
import org.smallmind.scribe.pen.LoggerManager;

public abstract class Worker<T>
implements Runnable {
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final CountDownLatch exitLatch = new CountDownLatch(1);
    private final WorkQueue<T> workQueue;
    private Thread runnableThread;

    public Worker(WorkQueue<T> workQueue) {
        this.workQueue = workQueue;
    }

    public abstract void engageWork(T var1) throws Throwable;

    public abstract void close() throws Exception;

    public void stop() throws Exception {
        if (this.stopped.compareAndSet(false, true)) {
            this.close();
            if (this.runnableThread != null) {
                this.runnableThread.interrupt();
            }
        }
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long idleStart = System.nanoTime();
        try {
            this.runnableThread = Thread.currentThread();
            while (!this.stopped.get()) {
                try {
                    T transfer = this.workQueue.poll(1L, TimeUnit.SECONDS);
                    if (transfer == null) continue;
                    Instrument.with(Worker.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("event", ClaxonTag.WORKER_IDLE.getDisplay())}).update(System.nanoTime() - idleStart, TimeUnit.NANOSECONDS);
                    this.engageWork(transfer);
                }
                catch (InterruptedException interruptedException) {
                    if (this.stopped.get()) continue;
                    LoggerManager.getLogger(this.getClass()).error((Throwable)interruptedException);
                }
                catch (Throwable throwable) {
                    LoggerManager.getLogger(this.getClass()).error(throwable);
                }
                finally {
                    idleStart = System.nanoTime();
                }
            }
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

