/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.worker;

import java.lang.reflect.Array;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.LazyBuilder;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.nutsnbolts.util.ComponentStatus;
import org.smallmind.phalanx.worker.ClaxonTag;
import org.smallmind.phalanx.worker.TransferringWorkQueue;
import org.smallmind.phalanx.worker.WorkManagerException;
import org.smallmind.phalanx.worker.WorkQueue;
import org.smallmind.phalanx.worker.Worker;
import org.smallmind.phalanx.worker.WorkerFactory;
import org.smallmind.scribe.pen.LoggerManager;

public class WorkManager<W extends Worker<T>, T> {
    private final AtomicReference<ComponentStatus> statusRef = new AtomicReference<ComponentStatus>(ComponentStatus.STOPPED);
    private final WorkQueue<T> workQueue;
    private final Class<W> workerClass;
    private final int concurrencyLimit;
    private W[] workers;

    public WorkManager(Class<W> workerClass, int concurrencyLimit) {
        this(workerClass, concurrencyLimit, new TransferringWorkQueue());
    }

    public WorkManager(Class<W> workerClass, int concurrencyLimit, WorkQueue<T> workQueue) {
        this.workerClass = workerClass;
        this.concurrencyLimit = concurrencyLimit;
        this.workQueue = workQueue;
    }

    public int getConcurrencyLimit() {
        return this.concurrencyLimit;
    }

    public void startUp(WorkerFactory<W, T> workerFactory) throws InterruptedException {
        if (this.statusRef.compareAndSet(ComponentStatus.STOPPED, ComponentStatus.STARTING)) {
            this.workers = (Worker[])Array.newInstance(this.workerClass, this.concurrencyLimit);
            for (int index = 0; index < this.workers.length; ++index) {
                this.workers[index] = workerFactory.createWorker(this.workQueue);
                Thread workerThread = new Thread((Runnable)this.workers[index]);
                workerThread.setDaemon(true);
                workerThread.start();
            }
            this.statusRef.set(ComponentStatus.STARTED);
        } else {
            while (ComponentStatus.STARTING.equals((Object)this.statusRef.get())) {
                Thread.sleep(100L);
            }
        }
    }

    public void execute(T work) throws Throwable {
        if (!ComponentStatus.STARTED.equals((Object)this.statusRef.get())) {
            throw new WorkManagerException("%s is not in the 'started' state", WorkManager.class.getSimpleName());
        }
        Instrument.with(WorkManager.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("event", ClaxonTag.ACQUIRE_WORKER.getDisplay())}).on(() -> {
            boolean success;
            while (!(success = this.workQueue.offer(work, 1L, TimeUnit.SECONDS))) {
            }
        });
    }

    public void shutDown() throws InterruptedException {
        if (this.statusRef.compareAndSet(ComponentStatus.STARTED, ComponentStatus.STOPPING)) {
            for (W worker : this.workers) {
                try {
                    ((Worker)worker).stop();
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(WorkManager.class).error((Throwable)exception);
                }
            }
            this.statusRef.set(ComponentStatus.STOPPED);
        } else {
            while (ComponentStatus.STOPPING.equals((Object)this.statusRef.get())) {
                Thread.sleep(100L);
            }
        }
    }
}

