/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Message;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.MeterFactory;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.phalanx.wire.TransportException;
import org.smallmind.phalanx.wire.signal.InvocationSignal;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.transport.ResponseTransmitter;
import org.smallmind.phalanx.wire.transport.WireInvocationCircuit;
import org.smallmind.phalanx.wire.transport.WireProperty;
import org.smallmind.phalanx.worker.WorkQueue;
import org.smallmind.phalanx.worker.Worker;

public class InvocationWorker
extends Worker<Message> {
    private final ResponseTransmitter responseTransmitter;
    private final WireInvocationCircuit invocationCircuit;
    private final SignalCodec signalCodec;
    private final byte[] buffer;

    public InvocationWorker(WorkQueue<Message> workQueue, ResponseTransmitter responseTransmitter, WireInvocationCircuit invocationCircuit, SignalCodec signalCodec, int maximumMessageLength) {
        super(workQueue);
        this.responseTransmitter = responseTransmitter;
        this.invocationCircuit = invocationCircuit;
        this.signalCodec = signalCodec;
        this.buffer = new byte[maximumMessageLength];
    }

    @Override
    public void engageWork(Message message) throws Throwable {
        if (((BytesMessage)message).getBodyLength() > (long)this.buffer.length) {
            throw new TransportException("Message length exceeds maximum capacity %d > %d", ((BytesMessage)message).getBodyLength(), this.buffer.length);
        }
        ((BytesMessage)message).readBytes(this.buffer);
        InvocationSignal invocationSignal = this.signalCodec.decode(this.buffer, 0, (int)((BytesMessage)message).getBodyLength(), InvocationSignal.class);
        Instrument.with(InvocationWorker.class, (MeterBuilder)MeterFactory.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("operation", "invoke"), new Tag("service", invocationSignal.getRoute().getService()), new Tag("method", invocationSignal.getRoute().getFunction().getName())}).on(() -> this.invocationCircuit.handle(this.responseTransmitter, this.signalCodec, message.getStringProperty(WireProperty.CALLER_ID.getKey()), message.getJMSMessageID(), invocationSignal));
    }

    @Override
    public void close() {
    }
}

