/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.jms.jndi;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import javax.naming.Context;
import org.smallmind.phalanx.wire.TransportException;
import org.smallmind.phalanx.wire.transport.jms.ManagedObjectFactory;
import org.smallmind.phalanx.wire.transport.jms.jndi.JmsConnectionDetails;

public class JndiManagedObjectFactory
implements ManagedObjectFactory {
    private final JmsConnectionDetails messageConnectionDetails;

    public JndiManagedObjectFactory(JmsConnectionDetails jmsConnectionDetails) {
        this.messageConnectionDetails = jmsConnectionDetails;
    }

    @Override
    public Connection createConnection() throws TransportException {
        try {
            QueueConnectionFactory queueConnectionFactory;
            try (Context javaEnvironment = (Context)this.messageConnectionDetails.getContextPool().getComponent();){
                queueConnectionFactory = (QueueConnectionFactory)javaEnvironment.lookup(this.messageConnectionDetails.getConnectionFactoryName());
            }
            return queueConnectionFactory.createQueueConnection(this.messageConnectionDetails.getUserName(), this.messageConnectionDetails.getPassword());
        }
        catch (Exception exception) {
            throw new TransportException(exception);
        }
    }

    @Override
    public Destination getDestination() throws TransportException {
        try {
            Queue queue;
            try (Context javaEnvironment = (Context)this.messageConnectionDetails.getContextPool().getComponent();){
                queue = (Queue)javaEnvironment.lookup(this.messageConnectionDetails.getDestinationName());
            }
            return queue;
        }
        catch (Exception exception) {
            throw new TransportException(exception);
        }
    }
}

