/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.MeterFactory;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.nutsnbolts.util.SnowflakeId;
import org.smallmind.phalanx.wire.signal.InvocationSignal;
import org.smallmind.phalanx.wire.signal.SignalCodec;
import org.smallmind.phalanx.wire.transport.ResponseTransport;
import org.smallmind.phalanx.wire.transport.TransportState;
import org.smallmind.phalanx.wire.transport.WireInvocationCircuit;
import org.smallmind.phalanx.wire.transport.WiredService;
import org.smallmind.phalanx.wire.transport.rest.RestResponseTransmitter;
import org.smallmind.web.jersey.aop.Validated;

@Path(value="/org/smallmind/wire/transport/response")
public class RestResponseTransport
implements ResponseTransport {
    private final AtomicReference<TransportState> stateRef = new AtomicReference<TransportState>(TransportState.PLAYING);
    private final WireInvocationCircuit invocationCircuit = new WireInvocationCircuit();
    private final String instanceId = SnowflakeId.newInstance().generateDottedString();
    private SignalCodec signalCodec;

    public void setSignalCodec(SignalCodec signalCodec) {
        this.signalCodec = signalCodec;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String register(Class<?> serviceInterface, WiredService targetService) throws Exception {
        this.invocationCircuit.register(serviceInterface, targetService);
        return this.instanceId;
    }

    @Override
    public TransportState getState() {
        return this.stateRef.get();
    }

    @Override
    public void play() {
    }

    @Override
    public void pause() throws Exception {
        throw new UnsupportedOperationException();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Validated
    public Response invoke(@HeaderParam(value="X-SMALLMIND-WIRE-CALLER-ID") String callerId, @HeaderParam(value="X-SMALLMIND-WIRE-MESSAGE-ID") String messageId, InvocationSignal invocationSignal) throws Throwable {
        if (TransportState.PLAYING.equals((Object)this.stateRef.get())) {
            return (Response)Instrument.with(RestResponseTransport.class, (MeterBuilder)MeterFactory.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("operation", "invoke"), new Tag("service", invocationSignal.getRoute().getService()), new Tag("method", invocationSignal.getRoute().getFunction().getName())}).on(() -> {
                RestResponseTransmitter responseTransmitter = new RestResponseTransmitter();
                this.invocationCircuit.handle(responseTransmitter, this.signalCodec, callerId, messageId, invocationSignal);
                return responseTransmitter.getResultSignal();
            });
        }
        throw new ForbiddenException("The resource has been closed");
    }

    @Override
    public void close() {
        this.stateRef.set(TransportState.CLOSED);
    }
}

