/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.mock;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.phalanx.wire.transport.mock.MockMessage;
import org.smallmind.phalanx.wire.transport.mock.MockMessageListener;
import org.smallmind.phalanx.wire.transport.mock.MockQueue;
import org.smallmind.scribe.pen.LoggerManager;

public class MockTopic {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final QueueWorker worker;
    private final ConcurrentLinkedQueue<MockMessage> messageQueue = new ConcurrentLinkedQueue();
    private final ArrayList<MockMessageListener> listenerList = new ArrayList();

    public MockTopic() {
        this.worker = new QueueWorker();
        Thread thread = new Thread(this.worker);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MockMessageListener listener) {
        ArrayList<MockMessageListener> arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MockMessageListener listener) {
        ArrayList<MockMessageListener> arrayList = this.listenerList;
        synchronized (arrayList) {
            this.listenerList.remove(listener);
        }
    }

    public void send(MockMessage message) {
        this.messageQueue.add(message);
    }

    private class QueueWorker
    implements Runnable {
        private QueueWorker() {
        }

        public void close() {
            MockTopic.this.closed.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!MockTopic.this.closed.get()) {
                MockMessage message = MockTopic.this.messageQueue.poll();
                if (message != null) {
                    ArrayList<MockMessageListener> arrayList = MockTopic.this.listenerList;
                    synchronized (arrayList) {
                        for (MockMessageListener listener : MockTopic.this.listenerList) {
                            if (!listener.match(message.getProperties())) continue;
                            listener.handle(message);
                        }
                        continue;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(MockQueue.class).error((Throwable)interruptedException);
                }
            }
        }
    }
}

