/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.phalanx.wire.BuiltInType;
import org.smallmind.web.json.scaffold.fault.Fault;

public class SignatureUtility {
    private static final ConcurrentHashMap<String, Class<?>> SIGNATURE_MAP = new ConcurrentHashMap();

    public static String neutralEncode(Class<?> clazz) {
        if (clazz == null || Void.TYPE.equals(clazz) || Void.class.equals(clazz)) {
            return BuiltInType.VOID.getCode();
        }
        StringBuilder codeBuilder = new StringBuilder();
        if (clazz.isArray()) {
            int dimensions = 0;
            codeBuilder.append('[');
            while (clazz.isArray()) {
                ++dimensions;
                clazz = clazz.getComponentType();
            }
            codeBuilder.append(",".repeat(Math.max(0, dimensions - 1)));
            codeBuilder.append(']');
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                codeBuilder.insert(0, BuiltInType.BOOLEAN.getCode());
            } else if (clazz.equals(Byte.TYPE)) {
                codeBuilder.insert(0, BuiltInType.BYTE.getCode());
            } else if (clazz.equals(Short.TYPE)) {
                codeBuilder.insert(0, BuiltInType.SHORT.getCode());
            } else if (clazz.equals(Integer.TYPE)) {
                codeBuilder.insert(0, BuiltInType.INTEGER.getCode());
            } else if (clazz.equals(Long.TYPE)) {
                codeBuilder.insert(0, BuiltInType.LONG.getCode());
            } else if (clazz.equals(Float.TYPE)) {
                codeBuilder.insert(0, BuiltInType.FLOAT.getCode());
            } else if (clazz.equals(Double.TYPE)) {
                codeBuilder.insert(0, BuiltInType.DOUBLE.getCode());
            } else if (clazz.equals(Character.TYPE)) {
                codeBuilder.insert(0, BuiltInType.CHARACTER.getCode());
            }
        } else if (clazz.equals(String.class)) {
            codeBuilder.insert(0, BuiltInType.STRING.getCode());
        } else if (clazz.equals(Date.class)) {
            codeBuilder.insert(0, BuiltInType.DATE.getCode());
        } else if (clazz.equals(Fault.class)) {
            codeBuilder.insert(0, BuiltInType.FAULT.getCode());
        } else if (clazz.equals(Object.class)) {
            codeBuilder.insert(0, BuiltInType.OBJECT.getCode());
        } else {
            codeBuilder.insert(0, clazz.getSimpleName()).insert(0, '!');
        }
        return codeBuilder.toString();
    }

    public static String nativeEncode(Class<?> clazz) {
        if (clazz == null || Void.TYPE.equals(clazz) || Void.class.equals(clazz)) {
            return "V";
        }
        StringBuilder codeBuilder = new StringBuilder();
        while (clazz.isArray()) {
            codeBuilder.append("[");
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Boolean.TYPE)) {
                codeBuilder.append("Z");
            } else if (clazz.equals(Byte.TYPE)) {
                codeBuilder.append("B");
            } else if (clazz.equals(Short.TYPE)) {
                codeBuilder.append("S");
            } else if (clazz.equals(Integer.TYPE)) {
                codeBuilder.append("I");
            } else if (clazz.equals(Long.TYPE)) {
                codeBuilder.append("J");
            } else if (clazz.equals(Float.TYPE)) {
                codeBuilder.append("F");
            } else if (clazz.equals(Double.TYPE)) {
                codeBuilder.append("D");
            } else if (clazz.equals(Character.TYPE)) {
                codeBuilder.append("C");
            }
        } else {
            codeBuilder.append('L').append(clazz.getName().replace('.', '/')).append(';');
        }
        return codeBuilder.toString();
    }

    public static Class<?> nativeDecode(String type) throws ClassNotFoundException {
        return switch (type.charAt(0)) {
            case 'V' -> Void.class;
            case 'Z' -> Boolean.TYPE;
            case 'B' -> Byte.TYPE;
            case 'C' -> Character.TYPE;
            case 'S' -> Short.TYPE;
            case 'I' -> Integer.TYPE;
            case 'J' -> Long.TYPE;
            case 'F' -> Float.TYPE;
            case 'D' -> Double.TYPE;
            case 'L' -> SignatureUtility.getObjectType(type.substring(1, type.length() - 1).replace('/', '.'));
            case '[' -> SignatureUtility.getObjectType(type.replace('/', '.'));
            default -> throw new ClassNotFoundException("Unknown format for parameter signature(" + type + ")");
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getObjectType(String type) throws ClassNotFoundException {
        Class<?> objectType = SIGNATURE_MAP.get(type);
        if (objectType == null) {
            ConcurrentHashMap<String, Class<?>> concurrentHashMap = SIGNATURE_MAP;
            synchronized (concurrentHashMap) {
                objectType = SIGNATURE_MAP.get(type);
                if (objectType == null) {
                    objectType = Class.forName(type);
                    SIGNATURE_MAP.put(type, objectType);
                }
            }
        }
        return objectType;
    }
}

