/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.transport.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import org.smallmind.phalanx.wire.transport.jms.ConnectionManager;
import org.smallmind.phalanx.wire.transport.jms.MessageHandler;
import org.smallmind.phalanx.wire.transport.jms.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class QueueOperator
implements SessionEmployer,
MessageHandler {
    private final ConnectionManager connectionManager;
    private final Queue requestQueue;

    public QueueOperator(ConnectionManager connectionManager, Queue queue) {
        this.connectionManager = connectionManager;
        this.requestQueue = queue;
    }

    @Override
    public Destination getDestination() {
        return this.requestQueue;
    }

    @Override
    public String getMessageSelector() {
        return null;
    }

    @Override
    public BytesMessage createMessage() throws JMSException {
        return this.connectionManager.getSession(this).createBytesMessage();
    }

    @Override
    public void send(Message message) throws JMSException {
        this.connectionManager.getProducer(this).send(message);
        LoggerManager.getLogger(QueueOperator.class).debug("queue message sent(%s)...", new Object[]{message.getJMSMessageID()});
    }
}

