/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.phalanx.wire.signal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.LinkedList;
import java.util.Map;
import org.smallmind.nutsnbolts.util.IterableIterator;
import org.smallmind.phalanx.wire.WireContextManager;
import org.smallmind.phalanx.wire.signal.ProtoWireContext;
import org.smallmind.phalanx.wire.signal.WireContext;
import org.smallmind.web.json.scaffold.util.JsonCodec;

public class WireContextXmlAdapter
extends XmlAdapter<JsonNode, WireContext[]> {
    public WireContext[] unmarshal(JsonNode node) {
        LinkedList<WireContext> contextList = new LinkedList<WireContext>();
        if (node != null) {
            for (JsonNode elementNode : new IterableIterator(node.elements())) {
                if (elementNode.size() != 1) continue;
                Map.Entry topEntry = (Map.Entry)elementNode.properties().iterator().next();
                Class<? extends WireContext> contextClass = WireContextManager.getContextClass((String)topEntry.getKey());
                if (contextClass != null) {
                    contextList.add((WireContext)JsonCodec.convert(topEntry.getValue(), contextClass));
                    continue;
                }
                contextList.add(new ProtoWireContext((String)topEntry.getKey(), topEntry.getValue()));
            }
        }
        WireContext[] contexts = new WireContext[contextList.size()];
        contextList.toArray(contexts);
        return contexts;
    }

    public JsonNode marshal(WireContext[] wireContexts) throws JsonProcessingException {
        if (wireContexts == null || wireContexts.length == 0) {
            return null;
        }
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode(wireContexts.length);
        for (WireContext wireContext : wireContexts) {
            ObjectNode objectNode;
            if (wireContext instanceof ProtoWireContext) {
                objectNode = JsonNodeFactory.instance.objectNode();
                objectNode.set(((ProtoWireContext)wireContext).getSkin(), JsonCodec.writeAsJsonNode((Object)((ProtoWireContext)wireContext).getGuts()));
                arrayNode.add((JsonNode)objectNode);
                continue;
            }
            objectNode = JsonNodeFactory.instance.objectNode();
            XmlRootElement xmlRootElementAnnotation = wireContext.getClass().getAnnotation(XmlRootElement.class);
            objectNode.set(xmlRootElementAnnotation == null ? wireContext.getClass().getSimpleName() : xmlRootElementAnnotation.name(), JsonCodec.writeAsJsonNode((Object)wireContext));
            arrayNode.add((JsonNode)objectNode);
        }
        return arrayNode;
    }
}

