/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.plumber.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class SocketChannelPipe {
    private SocketChannel downstreamSocketChannel;
    private SocketChannel upstreamSocketChannel;
    private ByteBuffer buffer;

    public SocketChannelPipe(SocketChannel downstreamSocketChannel, SocketChannel upstreamSocketChannel, int bufferSize) {
        this.downstreamSocketChannel = downstreamSocketChannel;
        this.upstreamSocketChannel = upstreamSocketChannel;
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    public void startPipe() throws IOException {
        boolean downstreamOpen = true;
        boolean upstreamOpen = true;
        this.upstreamSocketChannel.configureBlocking(false);
        this.downstreamSocketChannel.configureBlocking(false);
        Selector readSelector = Selector.open();
        this.upstreamSocketChannel.register(readSelector, 1);
        this.downstreamSocketChannel.register(readSelector, 1);
        while (downstreamOpen || upstreamOpen) {
            if (readSelector.select() <= 0) continue;
            Set<SelectionKey> readyKeySet = readSelector.selectedKeys();
            Iterator<SelectionKey> readyKeyIter = readyKeySet.iterator();
            while (readyKeyIter.hasNext()) {
                SelectionKey readyKey = readyKeyIter.next();
                readyKeyIter.remove();
                SocketChannel readySocketChannel = (SocketChannel)readyKey.channel();
                if (downstreamOpen && readySocketChannel == this.downstreamSocketChannel) {
                    downstreamOpen = this.transferBuffer(this.downstreamSocketChannel, this.upstreamSocketChannel);
                    continue;
                }
                if (!upstreamOpen) continue;
                upstreamOpen = this.transferBuffer(this.upstreamSocketChannel, this.downstreamSocketChannel);
            }
        }
    }

    private boolean transferBuffer(SocketChannel inChannel, SocketChannel outChannel) throws IOException {
        int bytesRead;
        int totalBytes = 0;
        while ((bytesRead = inChannel.read(this.buffer)) > 0) {
            totalBytes += bytesRead;
            this.buffer.flip();
            while (this.buffer.hasRemaining()) {
                outChannel.write(this.buffer);
            }
            this.buffer.clear();
        }
        if (totalBytes > 0) {
            return true;
        }
        inChannel.socket().shutdownInput();
        outChannel.socket().shutdownOutput();
        return false;
    }
}

