/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.plumber.io;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.nutsnbolts.util.Counter;
import org.smallmind.plumber.io.SocketWorker;
import org.smallmind.plumber.io.SocketWorkerFactory;
import org.smallmind.quorum.pool.component.ComponentFactory;
import org.smallmind.quorum.pool.component.ComponentPool;
import org.smallmind.quorum.pool.component.PooledComponent;
import org.smallmind.scribe.pen.Logger;

public class ServerSocketHerald
implements ComponentFactory<SocketWorker>,
Runnable {
    public static final int NO_THROTTLE = -1;
    private final Counter acceptCounter;
    private Logger logger;
    private CountDownLatch exitLatch;
    private CountDownLatch pulseLatch;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private ComponentPool<SocketWorker> workerPool;
    private SocketWorkerFactory workerFactory;
    private ServerSocket serverSocket;
    private int maxAccepted;

    public ServerSocketHerald(Logger logger, SocketWorkerFactory workerFactory, ServerSocket serverSocket, int maxAccepted, int poolSize) throws IOException {
        this.logger = logger;
        this.workerFactory = workerFactory;
        this.serverSocket = serverSocket;
        this.maxAccepted = maxAccepted;
        serverSocket.setSoTimeout(1000);
        this.acceptCounter = new Counter();
        this.pulseLatch = new CountDownLatch(1);
        this.exitLatch = new CountDownLatch(1);
        this.workerPool = new ComponentPool((ComponentFactory)this, poolSize, 0L);
    }

    public SocketWorker createComponent() throws Exception {
        return this.workerFactory.createWorker(this.logger, this);
    }

    public void finish() throws InterruptedException {
        if (this.finished.compareAndSet(false, true)) {
            this.pulseLatch.countDown();
        }
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this.finished.get()) {
                try {
                    boolean annointed = false;
                    Counter counter = this.acceptCounter;
                    // MONITORENTER : counter
                    if (this.maxAccepted < 0 || this.acceptCounter.getCount() < this.maxAccepted) {
                        annointed = true;
                    }
                    // MONITOREXIT : counter
                    if (annointed) {
                        try {
                            Socket clientSocket = this.serverSocket.accept();
                            counter = this.acceptCounter;
                            // MONITORENTER : counter
                            this.acceptCounter.inc();
                            // MONITOREXIT : counter
                            SocketWorker worker = (SocketWorker)this.workerPool.getComponent();
                            worker.setSocket(clientSocket);
                            Thread workThread = new Thread(worker);
                            workThread.setDaemon(true);
                            workThread.start();
                        }
                        catch (SocketTimeoutException t) {
                            this.logger.error((Throwable)t);
                        }
                        continue;
                    }
                    try {
                        this.pulseLatch.await(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error((Throwable)interruptedException);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                }
            }
            return;
        }
        finally {
            this.exitLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(SocketWorker worker) {
        this.workerPool.returnComponent((PooledComponent)worker);
        Counter counter = this.acceptCounter;
        synchronized (counter) {
            this.acceptCounter.dec();
        }
    }
}

