/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.plumber.http;

import java.io.IOException;
import java.net.ServerSocket;
import org.smallmind.nutsnbolts.command.CommandException;
import org.smallmind.nutsnbolts.command.CommandLineParser;
import org.smallmind.nutsnbolts.command.CommandSet;
import org.smallmind.plumber.http.RecordingSocketWorkerFactory;
import org.smallmind.plumber.io.ServerSocketHerald;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.LoggerManager;

public class HTTPRecorder {
    private static final String[] REQUIRED_ARGUMENTS = new String[]{"localport", "remotehost", "remoteport", "buffer", "log"};
    private Logger logger;
    private String remoteHost;
    private int localPort;
    private int remotePort;
    private int buffer;

    public HTTPRecorder(int localPort, String remoteHost, int remotePort, int buffer, Logger logger) {
        this.localPort = localPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.buffer = buffer;
        this.logger = logger;
    }

    public void record() throws IOException {
        ServerSocket serverSocket = new ServerSocket(this.localPort);
        serverSocket.setReuseAddress(true);
        ServerSocketHerald herald = new ServerSocketHerald(this.logger, new RecordingSocketWorkerFactory(this.remoteHost, this.remotePort, this.buffer), serverSocket, -1, 8);
        Thread heraldThread = new Thread(herald);
        heraldThread.start();
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws CommandException, IOException {
        CommandSet commandSet = CommandLineParser.parseCommands((String[])args);
        if (!commandSet.containsAllCommands(REQUIRED_ARGUMENTS)) {
            System.out.println("HTTPRecorder [localport] [remotehost] [remoteport] [buffer] [log]");
        } else {
            int localPort = Integer.parseInt(commandSet.getArgument("localport"));
            int remotePort = Integer.parseInt(commandSet.getArgument("remoteport"));
            int buffer = Integer.parseInt(commandSet.getArgument("buffer"));
            HTTPRecorder HTTPRecorder2 = new HTTPRecorder(localPort, commandSet.getArgument("remotehost"), remotePort, buffer, LoggerManager.getLogger((String)commandSet.getArgument("log")));
            HTTPRecorder2.record();
        }
    }
}

