/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.plumber.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.smallmind.nutsnbolts.util.RotaryLock;

public class RecordingSocketPipe {
    private static final int UPSTREAM = 0;
    private static final int DOWNSTREAM = 1;
    private IOException threadException = null;
    private Socket downstreamSocket;
    private Socket upstreamSocket;
    private int bufferSize;

    public RecordingSocketPipe(Socket downstreamSocket, Socket upstreamSocket, int bufferSize) {
        this.downstreamSocket = downstreamSocket;
        this.upstreamSocket = upstreamSocket;
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPipe() throws IOException {
        RotaryLock rotaryLock;
        Thread lockThread = Thread.currentThread();
        RotaryLock rotaryLock2 = rotaryLock = new RotaryLock(2);
        synchronized (rotaryLock2) {
            block5: {
                this.startTransfer(lockThread, rotaryLock, 0, this.downstreamSocket, this.upstreamSocket, true);
                this.startTransfer(lockThread, rotaryLock, 1, this.upstreamSocket, this.downstreamSocket, false);
                try {
                    rotaryLock.wait();
                }
                catch (InterruptedException i) {
                    if (this.threadException == null) break block5;
                    throw this.threadException;
                }
            }
        }
    }

    private void startTransfer(Thread lockThread, RotaryLock rotaryLock, int condition, Socket inputSocket, Socket outputSocket, boolean record) throws IOException {
        Thread transferThread = new Thread(new TransferHandler(lockThread, rotaryLock, condition, inputSocket, outputSocket, record));
        transferThread.setDaemon(true);
        transferThread.start();
    }

    public class TransferHandler
    implements Runnable {
        private final Thread lockThread;
        private RotaryLock rotaryLock;
        private Socket inputSocket;
        private Socket outputSocket;
        private InputStream inputStream;
        private OutputStream outputStream;
        private boolean record;
        private int condition;
        private byte[] buffer;

        public TransferHandler(Thread lockThread, RotaryLock rotaryLock, int condition, Socket inputSocket, Socket outputSocket, boolean record) throws IOException {
            this.lockThread = lockThread;
            this.rotaryLock = rotaryLock;
            this.condition = condition;
            this.inputSocket = inputSocket;
            this.outputSocket = outputSocket;
            this.record = record;
            this.inputStream = inputSocket.getInputStream();
            this.outputStream = outputSocket.getOutputStream();
            this.buffer = new byte[RecordingSocketPipe.this.bufferSize];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int bytesRead;
                while ((bytesRead = this.inputStream.read(this.buffer)) >= 0) {
                    if (this.record) {
                        System.out.print(new String(this.buffer, 0, bytesRead));
                    }
                    this.outputStream.write(this.buffer, 0, bytesRead);
                }
                this.inputSocket.shutdownInput();
                this.outputSocket.shutdownOutput();
                this.rotaryLock.unlock(this.condition);
            }
            catch (IOException ioException) {
                Thread thread = this.lockThread;
                synchronized (thread) {
                    if (RecordingSocketPipe.this.threadException == null) {
                        RecordingSocketPipe.this.threadException = ioException;
                        this.lockThread.interrupt();
                    }
                }
            }
        }
    }
}

