/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.plumber.io;

import java.io.IOException;
import java.net.Socket;
import org.smallmind.plumber.io.ServerSocketHerald;
import org.smallmind.quorum.pool.simple.PooledComponent;
import org.smallmind.scribe.pen.Logger;
import org.smallmind.scribe.pen.LoggerManager;

public abstract class SocketWorker
implements PooledComponent,
Runnable {
    private Logger logger;
    private ServerSocketHerald herald;
    private Socket socket;

    public SocketWorker(Logger logger, ServerSocketHerald herald) {
        this.logger = logger;
        this.herald = herald;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public abstract void socketWork(Socket var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.socket == null) {
                throw new IllegalArgumentException("No socket has been set on this SocketWorker");
            }
            if (this.socket.isClosed()) {
                throw new IllegalArgumentException("The socket has already been closed");
            }
            try {
                this.socketWork(this.socket);
            }
            finally {
                this.socket.close();
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        finally {
            this.herald.returnConnection(this);
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void terminate() {
        try {
            this.close();
        }
        catch (IOException ioException) {
            LoggerManager.getLogger(SocketWorker.class).error((Throwable)ioException);
        }
    }
}

