/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.plumber.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.nutsnbolts.util.Counter;
import org.smallmind.plumber.nio.SocketChannelWorker;
import org.smallmind.plumber.nio.SocketChannelWorkerFactory;
import org.smallmind.quorum.pool.simple.ComponentFactory;
import org.smallmind.quorum.pool.simple.ComponentPool;
import org.smallmind.quorum.pool.simple.PooledComponent;
import org.smallmind.quorum.pool.simple.SimplePoolConfig;
import org.smallmind.scribe.pen.Logger;

public class ServerSocketChannelHerald
implements ComponentFactory<SocketChannelWorker>,
Runnable {
    public static final int NO_THROTTLE = -1;
    private final Counter acceptCounter;
    private Logger logger;
    private CountDownLatch exitLatch;
    private CountDownLatch pulseLatch;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private ComponentPool<SocketChannelWorker> workerPool;
    private SocketChannelWorkerFactory workerFactory;
    private Selector acceptSelector;
    private int maxAccepted;

    public ServerSocketChannelHerald(Logger logger, SocketChannelWorkerFactory workerFactory, ServerSocketChannel serverSocketChannel, int maxAccepted, int poolSize) throws IOException {
        this.logger = logger;
        this.workerFactory = workerFactory;
        this.maxAccepted = maxAccepted;
        serverSocketChannel.configureBlocking(false);
        this.acceptSelector = Selector.open();
        serverSocketChannel.register(this.acceptSelector, 16);
        this.acceptCounter = new Counter();
        this.pulseLatch = new CountDownLatch(1);
        this.exitLatch = new CountDownLatch(1);
        SimplePoolConfig simplePoolConfig = new SimplePoolConfig();
        simplePoolConfig.setAcquireWaitTimeMillis((long)poolSize);
        this.workerPool = new ComponentPool((ComponentFactory)this, simplePoolConfig);
    }

    public SocketChannelWorker createComponent() throws Exception {
        return this.workerFactory.createWorker(this.logger, this);
    }

    public void finish() throws InterruptedException {
        if (this.finished.compareAndSet(false, true)) {
            this.pulseLatch.countDown();
        }
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.finished.get()) {
                try {
                    if (this.acceptSelector.select(1000L) <= 0) continue;
                    Set<SelectionKey> readyKeySet = this.acceptSelector.selectedKeys();
                    Iterator<SelectionKey> readyKeyIter = readyKeySet.iterator();
                    while (readyKeyIter.hasNext() && !this.finished.get()) {
                        boolean accepted = false;
                        Counter counter = this.acceptCounter;
                        synchronized (counter) {
                            if (this.maxAccepted < 0 || this.acceptCounter.getCount() < this.maxAccepted) {
                                this.acceptCounter.inc();
                                accepted = true;
                                SelectionKey readyKey = readyKeyIter.next();
                                readyKeyIter.remove();
                                ServerSocketChannel readyChannel = (ServerSocketChannel)readyKey.channel();
                                SocketChannelWorker worker = (SocketChannelWorker)this.workerPool.getComponent();
                                worker.setChannel(readyChannel);
                                Thread workThread = new Thread(worker);
                                workThread.setDaemon(true);
                                workThread.start();
                            }
                            if (accepted) continue;
                        }
                        try {
                            this.pulseLatch.await(100L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            this.logger.error((Throwable)interruptedException);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                }
            }
            return;
        }
        finally {
            this.exitLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(SocketChannelWorker worker) {
        this.workerPool.returnComponent((PooledComponent)worker);
        Counter counter = this.acceptCounter;
        synchronized (counter) {
            this.acceptCounter.dec();
        }
    }
}

