/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.cache.indigenous;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import org.smallmind.quorum.cache.CacheException;
import org.smallmind.quorum.cache.KeyLock;
import org.smallmind.quorum.cache.indigenous.AbstractCache;
import org.smallmind.quorum.cache.indigenous.CacheAccumulator;
import org.smallmind.quorum.cache.indigenous.CacheExpirationPolicy;
import org.smallmind.quorum.cache.indigenous.CacheMetaData;
import org.smallmind.quorum.cache.indigenous.CacheReference;
import org.smallmind.quorum.cache.indigenous.CacheSource;
import org.smallmind.quorum.cache.indigenous.OrderedCacheEntry;

public class OrderedCache<D extends CacheMetaData, K, V, E extends OrderedCacheEntry<D, V>>
extends AbstractCache<K, V, E> {
    private ConcurrentSkipListMap<D, K> cacheKeyMap;
    private CacheAccumulator<D, K, E> cacheAccumulator;

    public OrderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheAccumulator<D, K, E> cacheAccumulator, Comparator<D> metaDataComparator) throws CacheException {
        this(cacheName, cacheSource, cacheAccumulator, metaDataComparator, null, 16, 0.75f, 16, 0L);
    }

    public OrderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheAccumulator<D, K, E> cacheAccumulator, Comparator<D> metaDataComparator, int initialCapacity, float loadFactor, int concurrencyLevel) throws CacheException {
        this(cacheName, cacheSource, cacheAccumulator, metaDataComparator, null, initialCapacity, loadFactor, concurrencyLevel, 0L);
    }

    public OrderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheAccumulator<D, K, E> cacheAccumulator, Comparator<D> metaDataComparator, int initialCapacity, float loadFactor, int concurrencyLevel, long externalLockTimeout) throws CacheException {
        this(cacheName, cacheSource, cacheAccumulator, metaDataComparator, null, initialCapacity, loadFactor, concurrencyLevel, externalLockTimeout);
    }

    public OrderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheAccumulator<D, K, E> cacheAccumulator, Comparator<D> metaDataComparator, CacheExpirationPolicy<E> cacheExpirationPolicy) throws CacheException {
        this(cacheName, cacheSource, cacheAccumulator, metaDataComparator, cacheExpirationPolicy, 16, 0.75f, 16, 0L);
    }

    public OrderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheAccumulator<D, K, E> cacheAccumulator, Comparator<D> metaDataComparator, CacheExpirationPolicy<E> cacheExpirationPolicy, int initialCapacity, float loadFactor, int concurrencyLevel) throws CacheException {
        this(cacheName, cacheSource, cacheAccumulator, metaDataComparator, cacheExpirationPolicy, initialCapacity, loadFactor, concurrencyLevel, 0L);
    }

    public OrderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheAccumulator<D, K, E> cacheAccumulator, Comparator<D> metaDataComparator, CacheExpirationPolicy<E> cacheExpirationPolicy, int initialCapacity, float loadFactor, int concurrencyLevel, long externalLockTimeout) throws CacheException {
        super(cacheName, cacheSource, cacheExpirationPolicy, initialCapacity, loadFactor, concurrencyLevel, externalLockTimeout);
        this.cacheAccumulator = cacheAccumulator;
        this.cacheKeyMap = new ConcurrentSkipListMap(metaDataComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(KeyLock keyLock, K key) throws CacheException {
        if (this.isClosed()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        ReentrantLock stripeLock = this.lockStripe(key);
        try {
            this.gateKey(keyLock, key);
            OrderedCacheEntry orderedCacheEntry = (OrderedCacheEntry)this.expireEntry(key);
            if (orderedCacheEntry != null) {
                if (this.cacheKeyMap.remove(orderedCacheEntry.getCacheMetaData()) == null) {
                    throw new CacheException("Attempt to remove key(%s) succeeded, but its related metadata was not present in the AbstractCache", key);
                }
                this.cacheAccumulator.remove(orderedCacheEntry.getCacheMetaData());
                Object v = orderedCacheEntry.getEntry();
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            stripeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(KeyLock keyLock, K key, Object ... parameters) throws CacheException {
        if (this.isClosed()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        ReentrantLock stripeLock = this.lockStripe(key);
        try {
            this.gateKey(keyLock, key);
            OrderedCacheEntry orderedCacheEntry = (OrderedCacheEntry)this.getExistingEntry(keyLock, key);
            if (orderedCacheEntry != null) {
                Object cacheMetaData = orderedCacheEntry.getCacheMetaData();
                if (cacheMetaData.willUpdate()) {
                    this.cacheKeyMap.remove(cacheMetaData);
                    cacheMetaData.update();
                    this.cacheKeyMap.put(cacheMetaData, key);
                }
                Object v = orderedCacheEntry.getEntry();
                return v;
            }
            orderedCacheEntry = (OrderedCacheEntry)this.createNewEntry(key, parameters);
            if (orderedCacheEntry != null) {
                Object v = orderedCacheEntry.getEntry();
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            stripeLock.unlock();
        }
    }

    @Override
    protected E implantReference(CacheReference<K, E> cacheReference) throws CacheException {
        OrderedCacheEntry prevCacheEntry = (OrderedCacheEntry)super.implantReference(cacheReference);
        if (prevCacheEntry != null) {
            if (this.cacheKeyMap.remove(prevCacheEntry.getCacheMetaData()) == null) {
                throw new CacheException("Attempt to replace key(%s) succeeded, but the previous entry's related metadata was not present in the AbstractCache", cacheReference.getKey());
            }
            this.cacheAccumulator.remove(prevCacheEntry.getCacheMetaData());
        }
        this.cacheKeyMap.put(((OrderedCacheEntry)cacheReference.getCacheEntry()).getCacheMetaData(), cacheReference.getKey());
        this.cacheAccumulator.add(((OrderedCacheEntry)cacheReference.getCacheEntry()).getCacheMetaData());
        while (this.cacheAccumulator.isOverLimit() && !this.cacheKeyMap.isEmpty()) {
            Map.Entry<D, K> overLimitEntry = this.cacheKeyMap.firstEntry();
            if (!cacheReference.getKey().equals(overLimitEntry.getValue())) continue;
            throw new CacheException("Attempt by the Accumulator to remove the same key(%s) being inserted - you may want to look at either your CacheMetaData implementation or its Comparator", overLimitEntry.getKey());
        }
        return (E)prevCacheEntry;
    }
}

