/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.nutsnbolts.lang.StackTrace;
import org.smallmind.quorum.pool.connection.ConnectionCreationException;
import org.smallmind.quorum.pool.connection.ConnectionInstance;
import org.smallmind.quorum.pool.connection.ConnectionPin;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.pool.connection.ConnectionValidationException;
import org.smallmind.quorum.pool.connection.ConnectionWorker;
import org.smallmind.quorum.pool.connection.DeconstructionQueue;
import org.smallmind.scribe.pen.LoggerManager;

public class ConnectionPinManager<C> {
    private final ConnectionPool<C> connectionPool;
    private final HashMap<ConnectionInstance<C>, ConnectionPin<C>> backingMap = new HashMap();
    private final LinkedBlockingQueue<ConnectionPin<C>> freeQueue = new LinkedBlockingQueue();
    private final ReentrantReadWriteLock backingLock = new ReentrantReadWriteLock();
    private final DeconstructionQueue deconstructionQueue = new DeconstructionQueue();
    private final AtomicReference<State> stateRef = new AtomicReference<State>(State.STOPPED);
    private final AtomicInteger size = new AtomicInteger(0);

    public ConnectionPinManager(ConnectionPool<C> connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void startup() throws ConnectionPoolException {
        if (this.stateRef.compareAndSet(State.STOPPED, State.STARTING)) {
            this.deconstructionQueue.startup();
            this.backingLock.writeLock().lock();
            try {
                while (this.backingMap.size() < Math.max(this.connectionPool.getConnectionPoolConfig().getMinPoolSize(), this.connectionPool.getConnectionPoolConfig().getInitialPoolSize())) {
                    ConnectionInstance<C> connectionInstance = this.connectionPool.getConnectionInstanceFactory().createInstance(this.connectionPool);
                    ConnectionPin<C> connectionPin = new ConnectionPin<C>(this.connectionPool, this.deconstructionQueue, connectionInstance);
                    this.backingMap.put(connectionInstance, connectionPin);
                    this.freeQueue.put(connectionPin);
                }
                this.size.set(this.backingMap.size());
                this.stateRef.set(State.STARTED);
            }
            catch (Exception exception) {
                this.freeQueue.clear();
                this.backingMap.clear();
                this.size.set(0);
                this.stateRef.set(State.STOPPED);
                throw new ConnectionPoolException(exception);
            }
            finally {
                this.backingLock.writeLock().unlock();
            }
        }
        try {
            while (State.STARTING.equals((Object)this.stateRef.get())) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ConnectionPoolException(interruptedException);
        }
    }

    public ConnectionPin<C> serve() throws ConnectionPoolException {
        if (!State.STARTED.equals((Object)this.stateRef.get())) {
            throw new ConnectionPoolException("ConnectionPool has not been started", new Object[0]);
        }
        ConnectionPin<C> connectionPin = this.freeQueue.poll();
        if (connectionPin != null) {
            if (this.connectionPool.getConnectionPoolConfig().isTestOnAcquire() && !connectionPin.getConnectionInstance().validate()) {
                throw new ConnectionValidationException("A free connection was acquired, but failed to validate", new Object[0]);
            }
            return connectionPin;
        }
        connectionPin = this.addConnectionPin(true);
        if (connectionPin != null) {
            return connectionPin;
        }
        try {
            connectionPin = this.freeQueue.poll(this.connectionPool.getConnectionPoolConfig().getAcquireWaitTimeMillis(), TimeUnit.MILLISECONDS);
            if (connectionPin != null) {
                if (this.connectionPool.getConnectionPoolConfig().isTestOnAcquire() && !connectionPin.getConnectionInstance().validate()) {
                    throw new ConnectionValidationException("A free connection was acquired, but failed to validate", new Object[0]);
                }
                return connectionPin;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ConnectionPoolException(interruptedException);
        }
        throw new ConnectionPoolException("Exceeded the maximum acquire wait time(%d)", this.connectionPool.getConnectionPoolConfig().getAcquireWaitTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionPin<C> addConnectionPin(boolean forced) throws ConnectionCreationException, ConnectionValidationException {
        if (State.STARTED.equals((Object)this.stateRef.get())) {
            int minPoolSize = this.connectionPool.getConnectionPoolConfig().getMinPoolSize();
            int maxPoolSize = this.connectionPool.getConnectionPoolConfig().getMaxPoolSize();
            int currentSize = this.size.get();
            if (!(!forced && currentSize <= minPoolSize || maxPoolSize != 0 && currentSize >= maxPoolSize)) {
                this.backingLock.writeLock().lock();
                try {
                    currentSize = this.size.get();
                    if (!(!forced && currentSize <= minPoolSize || maxPoolSize != 0 && currentSize >= maxPoolSize)) {
                        ConnectionInstance<C> connectionInstance = this.manufactureConnectionInstance();
                        ConnectionPin<C> connectionPin = new ConnectionPin<C>(this.connectionPool, this.deconstructionQueue, connectionInstance);
                        this.backingMap.put(connectionInstance, connectionPin);
                        this.size.incrementAndGet();
                        ConnectionPin<C> connectionPin2 = connectionPin;
                        return connectionPin2;
                    }
                }
                finally {
                    this.backingLock.writeLock().unlock();
                }
            }
        }
        return null;
    }

    private ConnectionInstance<C> manufactureConnectionInstance() throws ConnectionCreationException, ConnectionValidationException {
        ConnectionInstance<C> connectionInstance;
        try {
            if (this.connectionPool.getConnectionPoolConfig().getConnectionTimeoutMillis() > 0L) {
                ConnectionWorker<C> connectionWorker = new ConnectionWorker<C>(this.connectionPool);
                Thread workerThread = new Thread(connectionWorker);
                workerThread.start();
                workerThread.join(this.connectionPool.getConnectionPoolConfig().getConnectionTimeoutMillis());
                if (connectionWorker.abort()) {
                    throw new ConnectionCreationException("Exceeded connection timeout(%d) waiting on connection creation", this.connectionPool.getConnectionPoolConfig().getConnectionTimeoutMillis());
                }
                connectionInstance = connectionWorker.getConnectionInstance();
            } else {
                connectionInstance = this.connectionPool.getConnectionInstanceFactory().createInstance(this.connectionPool);
            }
        }
        catch (ConnectionCreationException connectionCreationException) {
            throw connectionCreationException;
        }
        catch (Exception exception) {
            throw new ConnectionCreationException(exception);
        }
        if (this.connectionPool.getConnectionPoolConfig().isTestOnConnect() && !connectionInstance.validate()) {
            throw new ConnectionValidationException("A new connection was required, but failed to validate", new Object[0]);
        }
        return connectionInstance;
    }

    public void remove(ConnectionPin<C> connectionPin, boolean withPrejudice) {
        if (this.freeQueue.remove(connectionPin) || withPrejudice) {
            this.terminate(connectionPin.getConnectionInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(ConnectionInstance<C> connectionInstance) {
        ConnectionPin<C> connectionPin;
        this.backingLock.readLock().lock();
        try {
            connectionPin = this.backingMap.get(connectionInstance);
        }
        finally {
            this.backingLock.readLock().unlock();
        }
        if (connectionPin != null) {
            connectionPin.free();
            if (connectionPin.isTerminated()) {
                this.terminate(connectionPin.getConnectionInstance());
            } else if (State.STARTED.equals((Object)this.stateRef.get())) {
                try {
                    this.freeQueue.put(connectionPin);
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(ConnectionPinManager.class).error((Throwable)interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(ConnectionInstance<C> connectionInstance) {
        ConnectionPin<C> connectionPin;
        this.backingLock.writeLock().lock();
        try {
            connectionPin = this.backingMap.remove(connectionInstance);
        }
        finally {
            this.backingLock.writeLock().unlock();
        }
        if (connectionPin != null) {
            this.size.decrementAndGet();
            connectionPin.fizzle();
            try {
                connectionPin.getConnectionInstance().close();
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ConnectionPinManager.class).error((Throwable)exception);
            }
            try {
                ConnectionPin<C> replacementConnectionPin = this.addConnectionPin(false);
                if (replacementConnectionPin != null) {
                    this.freeQueue.put(replacementConnectionPin);
                }
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ConnectionPinManager.class).error((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws ConnectionPoolException {
        if (this.stateRef.compareAndSet(State.STARTED, State.STOPPING)) {
            while (this.size.get() > 0) {
                ConnectionInstance[] activeConnections;
                this.backingLock.readLock().lock();
                try {
                    Set<ConnectionInstance<C>> keys = this.backingMap.keySet();
                    activeConnections = new ConnectionInstance[keys.size()];
                    keys.toArray(activeConnections);
                }
                finally {
                    this.backingLock.readLock().unlock();
                }
                for (ConnectionInstance activeConnection : activeConnections) {
                    this.terminate(activeConnection);
                }
            }
            this.freeQueue.clear();
            try {
                this.deconstructionQueue.shutdown();
            }
            catch (InterruptedException interruptedException) {
                LoggerManager.getLogger(ConnectionPinManager.class).error((Throwable)interruptedException);
            }
            this.stateRef.set(State.STOPPED);
        } else {
            try {
                while (State.STOPPING.equals((Object)this.stateRef.get())) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ConnectionPoolException(interruptedException);
            }
        }
    }

    public int getPoolSize() {
        return this.size.get();
    }

    public int getFreeSize() {
        return this.freeQueue.size();
    }

    public int getProcessingSize() {
        return this.getPoolSize() - this.getFreeSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTrace[] getExistentialStackTraces() {
        LinkedList<StackTrace> stackTraceList = new LinkedList<StackTrace>();
        this.backingLock.readLock().lock();
        try {
            for (ConnectionPin<C> connectionPin : this.backingMap.values()) {
                if (this.freeQueue.contains(connectionPin)) continue;
                stackTraceList.add(new StackTrace(connectionPin.getExistentialStackTrace()));
            }
        }
        finally {
            this.backingLock.readLock().unlock();
        }
        StackTrace[] stackTraces = new StackTrace[stackTraceList.size()];
        stackTraceList.toArray(stackTraces);
        return stackTraces;
    }

    private static enum State {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

