/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.smallmind.quorum.pool.connection.DeconstructionFuse;
import org.smallmind.scribe.pen.LoggerManager;

public class DeconstructionQueue {
    private final ConcurrentSkipListMap<IgnitionKey, DeconstructionFuse> fuseMap = new ConcurrentSkipListMap();
    private final AtomicInteger ordinal = new AtomicInteger(0);
    private IgnitionWorker ignitionWorker;

    public void startup() {
        this.ignitionWorker = new IgnitionWorker();
        new Thread(this.ignitionWorker).start();
    }

    public int nextOrdinal() {
        return this.ordinal.incrementAndGet();
    }

    public void add(DeconstructionFuse deconstructionFuse) {
        this.fuseMap.put(new IgnitionKey(deconstructionFuse), deconstructionFuse);
    }

    public void remove(DeconstructionFuse deconstructionFuse) {
        this.fuseMap.remove(new IgnitionKey(deconstructionFuse));
    }

    public void shutdown() throws InterruptedException {
        this.ignitionWorker.shutdown();
    }

    private class IgnitionKey
    implements Comparable<IgnitionKey> {
        private final long ignitionTime;
        private final int ordinal;

        private IgnitionKey(DeconstructionFuse deconstructionFuse) {
            this(deconstructionFuse.getOrdinal(), deconstructionFuse.getIgnitionTime());
        }

        private IgnitionKey(int ordinal, long ignitionTime) {
            this.ordinal = ordinal;
            this.ignitionTime = ignitionTime;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public long getIgnitionTime() {
            return this.ignitionTime;
        }

        @Override
        public int compareTo(IgnitionKey key) {
            long comparison = this.ignitionTime - key.getIgnitionTime();
            if (comparison == 0L) {
                return this.ordinal - key.getOrdinal();
            }
            return (int)comparison;
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean equals(Object obj) {
            return obj instanceof IgnitionKey && this.ordinal == ((IgnitionKey)obj).getOrdinal();
        }
    }

    private class IgnitionWorker
    implements Runnable {
        private final CountDownLatch terminationLatch = new CountDownLatch(1);
        private final CountDownLatch exitLatch = new CountDownLatch(1);

        private IgnitionWorker() {
        }

        public void shutdown() throws InterruptedException {
            this.terminationLatch.countDown();
            this.exitLatch.await();
        }

        @Override
        public void run() {
            try {
                while (!this.terminationLatch.await(1L, TimeUnit.SECONDS)) {
                    IgnitionKey fuseKey;
                    IgnitionKey nowKey = new IgnitionKey(Integer.MAX_VALUE, System.currentTimeMillis());
                    while ((fuseKey = (IgnitionKey)DeconstructionQueue.this.fuseMap.firstKey()) != null && fuseKey.compareTo(nowKey) < 0) {
                        ((DeconstructionFuse)DeconstructionQueue.this.fuseMap.remove(fuseKey)).ignite();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LoggerManager.getLogger(DeconstructionQueue.class).error((Throwable)interruptedException);
            }
            this.exitLatch.countDown();
        }
    }
}

