/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.messaging;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.naming.Context;
import javax.naming.NamingException;
import org.smallmind.quorum.pool.component.ComponentFactory;
import org.smallmind.quorum.pool.component.ComponentPool;
import org.smallmind.quorum.pool.component.ComponentPoolException;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.transport.messaging.MessageSender;
import org.smallmind.quorum.transport.messaging.MessagingConnectionDetails;

public class MessagingTransmitter {
    private QueueConnection queueConnection;
    private QueueSession queueSession;
    private QueueSender queueSender;
    private ComponentPool<MessageSender> messageSenderPool;
    private String serviceSelector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagingTransmitter(MessagingConnectionDetails messagingConnectionDetails) throws ConnectionPoolException, NamingException, JMSException {
        QueueConnectionFactory queueConnectionFactory;
        Queue queue;
        Context javaEnvironment = (Context)messagingConnectionDetails.getContextPool().getConnection();
        try {
            queue = (Queue)javaEnvironment.lookup(messagingConnectionDetails.getDestinationName());
            queueConnectionFactory = (QueueConnectionFactory)javaEnvironment.lookup(messagingConnectionDetails.getConnectionFactoryName());
        }
        finally {
            javaEnvironment.close();
        }
        this.serviceSelector = messagingConnectionDetails.getServiceSelector();
        this.queueConnection = queueConnectionFactory.createQueueConnection(messagingConnectionDetails.getUserName(), messagingConnectionDetails.getPassword());
        this.queueSession = this.queueConnection.createQueueSession(false, 1);
        this.queueSender = this.queueSession.createSender(queue);
        this.messageSenderPool = new ComponentPool<MessageSender>(new MessageSenderComponentFactory(this), messagingConnectionDetails.getTransmissionPoolSize(), 0L);
        this.queueConnection.start();
    }

    public MessageSender borrowMessageSender() throws ComponentPoolException {
        return this.messageSenderPool.getComponent();
    }

    public void returnMessageSender(MessageSender messageSender) {
        this.messageSenderPool.returnComponent(messageSender);
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.queueSession.createObjectMessage(serializable);
    }

    public void sendMessage(TemporaryQueue temporaryQueue, Message message) throws JMSException {
        if (this.serviceSelector != null) {
            message.setStringProperty("Selection", this.serviceSelector);
        }
        message.setJMSReplyTo((Destination)temporaryQueue);
        this.queueSender.send(message);
    }

    public Object getResult(QueueReceiver queueReceiver) throws JMSException, InvocationTargetException {
        ObjectMessage objectMessage = (ObjectMessage)queueReceiver.receive();
        if (objectMessage.getBooleanProperty("Exception")) {
            throw new InvocationTargetException((Exception)objectMessage.getObject());
        }
        return objectMessage.getObject();
    }

    public void close() throws JMSException {
        this.queueConnection.stop();
        this.queueSender.close();
        this.queueSession.close();
        this.queueConnection.close();
    }

    public void finalize() throws JMSException {
        this.close();
    }

    private class MessageSenderComponentFactory
    implements ComponentFactory<MessageSender> {
        private MessagingTransmitter messagingTransmitter;

        public MessageSenderComponentFactory(MessagingTransmitter messagingTransmitter2) {
            this.messagingTransmitter = messagingTransmitter2;
        }

        @Override
        public MessageSender createComponent() throws JMSException {
            TemporaryQueue temporaryQueue = MessagingTransmitter.this.queueSession.createTemporaryQueue();
            return new MessageSender(this.messagingTransmitter, temporaryQueue, MessagingTransmitter.this.queueSession.createReceiver((Queue)temporaryQueue));
        }
    }
}

