/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection.jmx;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import javax.naming.NamingException;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.pool.connection.event.ConnectionPoolEventListener;
import org.smallmind.quorum.pool.connection.event.ErrorReportingConnectionPoolEvent;
import org.smallmind.quorum.pool.connection.event.LeaseTimeReportingConnectionPoolEvent;
import org.smallmind.quorum.pool.connection.jmx.ConnectionErrorOccurredNotification;
import org.smallmind.quorum.pool.connection.jmx.ConnectionLeaseTimeNotification;
import org.smallmind.quorum.pool.connection.jmx.ConnectionPoolMonitorsMBean;
import org.smallmind.quorum.pool.connection.jmx.ConnectionPoolRegistrationException;
import org.smallmind.quorum.pool.connection.remote.RemoteConnectionPoolEventListener;
import org.smallmind.quorum.pool.connection.remote.RemoteConnectionPoolSurface;
import org.smallmind.quorum.transport.remote.RemoteEndpointBinder;
import org.smallmind.quorum.transport.remote.RemoteProxyFactory;

public class ConnectionPoolMonitors
extends StandardEmitterMBean
implements ConnectionPoolMonitorsMBean,
ConnectionPoolEventListener {
    private static final String REGISTRY_NAME = ConnectionPoolMonitors.class.getPackage().getName() + ".listener";
    private final ConcurrentHashMap<String, RemoteConnectionPoolSurface> handleMap = new ConcurrentHashMap();
    private ObjectName objectName;
    private ConnectionPoolEventListener remoteListener;

    public ConnectionPoolMonitors() {
        super(ConnectionPoolMonitorsMBean.class, false, (NotificationEmitter)new NotificationBroadcasterSupport(new MBeanNotificationInfo(new String[]{"ERROR_OCCURRED"}, ConnectionErrorOccurredNotification.class.getName(), "Connection Error Occurred"), new MBeanNotificationInfo(new String[]{"LEASE_TIME"}, ConnectionLeaseTimeNotification.class.getName(), "Connection Lease Time")));
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws UnknownHostException, NoSuchMethodException, MalformedURLException, RemoteException, NamingException {
        RemoteEndpointBinder.bind(new RemoteConnectionPoolEventListener(this), REGISTRY_NAME);
        this.remoteListener = RemoteProxyFactory.generateRemoteProxy(ConnectionPoolEventListener.class, REGISTRY_NAME);
        this.objectName = objectName;
        return this.objectName;
    }

    @Override
    public void postRegister(Boolean success) {
    }

    @Override
    public void preDeregister() throws MalformedURLException, NotBoundException, RemoteException {
        for (RemoteConnectionPoolSurface remoteSurface : this.handleMap.values()) {
            remoteSurface.removeConnectionPoolEventListener(this.remoteListener);
        }
        this.handleMap.clear();
        RemoteEndpointBinder.unbind(REGISTRY_NAME);
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void reportConnectionErrorOccurred(ErrorReportingConnectionPoolEvent event) {
        this.sendNotification(new ConnectionErrorOccurredNotification(this.objectName, event.getException()));
    }

    @Override
    public void reportConnectionLeaseTime(LeaseTimeReportingConnectionPoolEvent event) {
        this.sendNotification(new ConnectionLeaseTimeNotification(this.objectName, event.getLeaseTimeNanos()));
    }

    private RemoteConnectionPoolSurface getRemoteSurface(String poolId) throws ConnectionPoolRegistrationException {
        RemoteConnectionPoolSurface remoteSurface = this.handleMap.get(poolId);
        if (remoteSurface == null) {
            throw new ConnectionPoolRegistrationException("Attempt to access an unregistered pool(%s)", poolId);
        }
        return remoteSurface;
    }

    @Override
    public synchronized void registerConnectionPool(String poolId, RemoteConnectionPoolSurface remoteSurface) throws UnknownHostException, NoSuchMethodException, MalformedURLException, RemoteException, NamingException {
        RemoteConnectionPoolSurface priorRemoteSurface = this.handleMap.put(poolId, remoteSurface);
        if (priorRemoteSurface != null) {
            priorRemoteSurface.removeConnectionPoolEventListener(this.remoteListener);
        }
        remoteSurface.addConnectionPoolEventListener(this.remoteListener);
    }

    @Override
    public synchronized void removeConnectionPool(String poolId) throws ConnectionPoolRegistrationException, MalformedURLException, NotBoundException, RemoteException {
        RemoteConnectionPoolSurface remoteSurface = this.handleMap.remove(poolId);
        if (remoteSurface == null) {
            throw new ConnectionPoolRegistrationException("Attempt to access an unregistered pool(%s)", poolId);
        }
        remoteSurface.removeConnectionPoolEventListener(this.remoteListener);
    }

    @Override
    public String getPoolName(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getPoolName();
    }

    @Override
    public void startup(String poolId) throws ConnectionPoolRegistrationException, ConnectionPoolException {
        this.getRemoteSurface(poolId).startup();
    }

    @Override
    public void shutdown(String poolId) throws ConnectionPoolRegistrationException, ConnectionPoolException {
        this.getRemoteSurface(poolId).shutdown();
    }

    @Override
    public int getPoolSize(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getPoolSize();
    }

    @Override
    public int getFreeSize(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getFreeSize();
    }

    @Override
    public int getProcessingSize(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getProcessingSize();
    }

    @Override
    public boolean isTestOnConnect(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).isTestOnConnect();
    }

    @Override
    public void setTestOnConnect(String poolId, boolean testOnConnect) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setTestOnConnect(testOnConnect);
    }

    @Override
    public boolean isTestOnAcquire(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).isTestOnAcquire();
    }

    @Override
    public void setTestOnAcquire(String poolId, boolean testOnAcquire) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setTestOnAcquire(testOnAcquire);
    }

    @Override
    public boolean isReportLeaseTimeNanos(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).isReportLeaseTimeNanos();
    }

    @Override
    public void setReportLeaseTimeNanos(String poolId, boolean reportLeaseTimeNanos) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setReportLeaseTimeNanos(reportLeaseTimeNanos);
    }

    @Override
    public boolean isExistentiallyAware(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).isExistentiallyAware();
    }

    @Override
    public void setExistentiallyAware(String poolId, boolean existentiallyAware) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setExistentiallyAware(existentiallyAware);
    }

    @Override
    public long getConnectionTimeoutMillis(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getConnectionTimeoutMillis();
    }

    @Override
    public void setConnectionTimeoutMillis(String poolId, long connectionTimeoutMillis) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setConnectionTimeoutMillis(connectionTimeoutMillis);
    }

    @Override
    public int getInitialPoolSize(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getInitialPoolSize();
    }

    @Override
    public int getMinPoolSize(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getMinPoolSize();
    }

    @Override
    public void setMinPoolSize(String poolId, int minPoolSize) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setMinPoolSize(minPoolSize);
    }

    @Override
    public int getMaxPoolSize(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getMaxPoolSize();
    }

    @Override
    public void setMaxPoolSize(String poolId, int maxPoolSize) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setMaxPoolSize(maxPoolSize);
    }

    @Override
    public long getAcquireWaitTimeMillis(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getAcquireWaitTimeMillis();
    }

    @Override
    public void setAcquireWaitTimeMillis(String poolId, long acquireWaitTimeMillis) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setAcquireWaitTimeMillis(acquireWaitTimeMillis);
    }

    @Override
    public int getMaxLeaseTimeSeconds(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getMaxLeaseTimeSeconds();
    }

    @Override
    public void setMaxLeaseTimeSeconds(String poolId, int leaseTimeSeconds) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setMaxLeaseTimeSeconds(leaseTimeSeconds);
    }

    @Override
    public int getMaxIdleTimeSeconds(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getMaxIdleTimeSeconds();
    }

    @Override
    public void setMaxIdleTimeSeconds(String poolId, int maxIdleTimeSeconds) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setMaxIdleTimeSeconds(maxIdleTimeSeconds);
    }

    @Override
    public int getUnreturnedConnectionTimeoutSeconds(String poolId) throws ConnectionPoolRegistrationException {
        return this.getRemoteSurface(poolId).getUnreturnedConnectionTimeoutSeconds();
    }

    @Override
    public void setUnreturnedConnectionTimeoutSeconds(String poolId, int unreturnedConnectionTimeoutSeconds) throws ConnectionPoolRegistrationException {
        this.getRemoteSurface(poolId).setUnreturnedConnectionTimeoutSeconds(unreturnedConnectionTimeoutSeconds);
    }
}

