/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.smallmind.nutsnbolts.context.Context;
import org.smallmind.nutsnbolts.context.ContextFactory;
import org.smallmind.quorum.transport.FauxMethod;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.MissingInvocationException;

public class MethodInvoker {
    private static final Class[] EMPTY_SIGNATURE = new Class[0];
    private static final Class[] OBJECT_SIGNATURE = new Class[]{Object.class};
    private Object targetObject;
    private HashMap<FauxMethod, Method> methodMap;

    public MethodInvoker(Object targetObject, Class[] proxyInterfaces) throws NoSuchMethodException {
        this.targetObject = targetObject;
        this.methodMap = new HashMap();
        for (Class proxyInterface : proxyInterfaces) {
            for (Method method : proxyInterface.getMethods()) {
                this.methodMap.put(new FauxMethod(method), method);
            }
        }
        Class<?> endpointClass = targetObject.getClass();
        Method toStringMethod = endpointClass.getMethod("toString", EMPTY_SIGNATURE);
        Method hashCodeMethod = endpointClass.getMethod("hashCode", EMPTY_SIGNATURE);
        Method equalsMethod = endpointClass.getMethod("equals", OBJECT_SIGNATURE);
        this.methodMap.put(new FauxMethod(toStringMethod), toStringMethod);
        this.methodMap.put(new FauxMethod(hashCodeMethod), hashCodeMethod);
        this.methodMap.put(new FauxMethod(equalsMethod), equalsMethod);
    }

    public Object remoteInvocation(InvocationSignal invocationSignal) throws Exception {
        Method serviceMethod = this.methodMap.get(invocationSignal.getFauxMethod());
        if (serviceMethod == null) {
            throw new MissingInvocationException();
        }
        if (invocationSignal.containsContexts()) {
            for (Context context : invocationSignal.getContexts()) {
                ContextFactory.pushContext((Context)context);
            }
        }
        try {
            Object object = serviceMethod.invoke(this.targetObject, invocationSignal.getArgs());
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof Exception) {
                throw (Exception)invocationTargetException.getCause();
            }
            throw invocationTargetException;
        }
        finally {
            if (invocationSignal.containsContexts()) {
                for (Context context : invocationSignal.getContexts()) {
                    ContextFactory.popContext((Context)context);
                }
            }
        }
    }
}

