/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.messaging;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueReceiver;
import javax.jms.TemporaryQueue;
import org.smallmind.quorum.transport.messaging.MessagingTransmitter;

public class MessageSender {
    private MessagingTransmitter messagingTransmitter;
    private TemporaryQueue temporaryQueue;
    private QueueReceiver queueReceiver;

    public MessageSender(MessagingTransmitter messagingTransmitter, TemporaryQueue temporaryQueue, QueueReceiver queueReceiver) {
        this.messagingTransmitter = messagingTransmitter;
        this.temporaryQueue = temporaryQueue;
        this.queueReceiver = queueReceiver;
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.messagingTransmitter.createObjectMessage(serializable);
    }

    public void sendMessage(Message message) throws JMSException {
        this.messagingTransmitter.sendMessage(this.temporaryQueue, message);
    }

    public Object getResult() throws JMSException, InvocationTargetException {
        return this.messagingTransmitter.getResult(this.queueReceiver);
    }

    public Message recieveMessage() throws JMSException {
        return this.queueReceiver.receive();
    }

    public void close() throws JMSException {
        this.queueReceiver.close();
        this.temporaryQueue.delete();
    }

    public void finalize() throws JMSException {
        this.close();
    }
}

