/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.cache.indigenous;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.nutsnbolts.util.IterableIterator;
import org.smallmind.quorum.cache.indigenous.AbstractCache;

public class ExpirationTimer<K>
implements Runnable {
    private transient CountDownLatch terminationLatch;
    private transient CountDownLatch exitLatch;
    private AbstractCache<K, ?, ?> cache;
    private AtomicBoolean processing = new AtomicBoolean(false);
    private AtomicBoolean finished = new AtomicBoolean(false);
    private int expirationTimerTickSeconds;

    public ExpirationTimer(AbstractCache<K, ?, ?> cache, int expirationTimerTickSeconds) {
        this.cache = cache;
        this.expirationTimerTickSeconds = expirationTimerTickSeconds;
        this.terminationLatch = new CountDownLatch(1);
        this.exitLatch = new CountDownLatch(1);
    }

    public boolean isProcessing() {
        return this.processing.get();
    }

    public void finish() {
        if (this.finished.compareAndSet(false, true)) {
            this.terminationLatch.countDown();
        }
        try {
            this.exitLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.finished.get()) {
                this.terminationLatch.await(this.expirationTimerTickSeconds, TimeUnit.SECONDS);
                if (this.finished.get() || !this.processing.compareAndSet(false, true)) continue;
                try {
                    for (Object e : new IterableIterator(this.cache.getKeyIterator())) {
                    }
                }
                finally {
                    this.processing.set(false);
                }
            }
        }
        catch (InterruptedException i) {
            this.finished.set(true);
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

