/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.juggler;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.smallmind.quorum.juggler.JugglingPin;
import org.smallmind.quorum.juggler.JugglingPinFactory;
import org.smallmind.quorum.juggler.NoAvailableResourceException;
import org.smallmind.scribe.pen.LoggerManager;

public class Juggler<P, R> {
    private final SecureRandom random = new SecureRandom();
    private final ConcurrentSkipListMap<Long, JugglingPin<R>> blackMap;
    private final Class<P> managedClass;
    private ProviderRecoveryWorker recoveryWorker = null;
    private ArrayList<JugglingPin<R>> sourcePins;
    private ArrayList<JugglingPin<R>> targetPins;

    public Juggler(Class<P> managedClass, int recoveryCheckSeconds, JugglingPinFactory<P, R> jugglingPinFactory, P ... providers) {
        this.managedClass = managedClass;
        this.sourcePins = new ArrayList(providers.length);
        this.targetPins = new ArrayList(providers.length);
        this.blackMap = new ConcurrentSkipListMap();
        for (P provider : providers) {
            this.targetPins.add(jugglingPinFactory.createJugglingPin(provider));
        }
        while (!this.targetPins.isEmpty()) {
            this.sourcePins.add(this.targetPins.remove(this.random.nextInt(this.targetPins.size())));
        }
        if (recoveryCheckSeconds > 0) {
            this.recoveryWorker = new ProviderRecoveryWorker(recoveryCheckSeconds);
            Thread recoveryThread = new Thread(this.recoveryWorker);
            recoveryThread.setDaemon(true);
            recoveryThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R pickResource() throws NoAvailableResourceException {
        Juggler juggler = this;
        synchronized (juggler) {
            while (!this.sourcePins.isEmpty() || !this.targetPins.isEmpty()) {
                if (this.sourcePins.isEmpty()) {
                    ArrayList<JugglingPin<R>> tempPins = this.sourcePins;
                    this.sourcePins = this.targetPins;
                    this.targetPins = tempPins;
                }
                JugglingPin<R> pin = this.sourcePins.remove(this.random.nextInt(this.sourcePins.size()));
                try {
                    R resource = pin.obtain();
                    this.targetPins.add(pin);
                    return resource;
                }
                catch (Exception exception) {
                    try {
                        LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                    }
                    finally {
                        this.blackMap.put(System.currentTimeMillis(), pin);
                    }
                }
            }
            throw new NoAvailableResourceException("All available resources(%s) have been black listed", this.managedClass.getSimpleName());
        }
    }

    public void shutdown() throws InterruptedException {
        if (this.recoveryWorker != null) {
            this.recoveryWorker.abort();
        }
    }

    private class ProviderRecoveryWorker
    implements Runnable {
        private CountDownLatch terminationLatch = new CountDownLatch(1);
        private CountDownLatch exitLatch = new CountDownLatch(1);
        private long recoveryCheckMillis;

        public ProviderRecoveryWorker(int recoveryCheckSeconds) {
            this.recoveryCheckMillis = recoveryCheckSeconds * 1000;
        }

        public void abort() throws InterruptedException {
            this.terminationLatch.countDown();
            this.exitLatch.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.terminationLatch.await(3L, TimeUnit.SECONDS)) {
                    Map.Entry firstEntry;
                    while ((firstEntry = Juggler.this.blackMap.firstEntry()) != null && (Long)firstEntry.getKey() + this.recoveryCheckMillis <= System.currentTimeMillis()) {
                        try {
                            ((JugglingPin)firstEntry.getValue()).obtain();
                            Juggler juggler = Juggler.this;
                            synchronized (juggler) {
                                JugglingPin recoveredPin = (JugglingPin)Juggler.this.blackMap.remove(firstEntry.getKey());
                                if (recoveredPin != null) {
                                    Juggler.this.targetPins.add(recoveredPin);
                                } else {
                                    LoggerManager.getLogger(ProviderRecoveryWorker.class).fatal("We've lost a resource(%s), which should never occur - please notify a system administrator", new Object[]{Juggler.this.managedClass.getSimpleName()});
                                }
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LoggerManager.getLogger(ProviderRecoveryWorker.class).error((Throwable)interruptedException);
            }
            this.exitLatch.countDown();
        }
    }
}

