/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.component;

import java.util.LinkedList;
import org.smallmind.quorum.pool.component.ComponentFactory;
import org.smallmind.quorum.pool.component.ComponentPoolException;

public class ComponentPool<T> {
    private ComponentFactory<T> componentFactory;
    private LinkedList<T> usedList;
    private LinkedList<T> freeList;
    private long acquireWaitTimeMillis;
    private int size;

    public ComponentPool(ComponentFactory<T> componentFactory, int size, long acquireWaitTimeMillis) {
        this.componentFactory = componentFactory;
        this.size = size;
        this.acquireWaitTimeMillis = acquireWaitTimeMillis;
        this.usedList = new LinkedList();
        this.freeList = new LinkedList();
    }

    public synchronized T getComponent() throws ComponentPoolException {
        T component = null;
        if (this.freeList.isEmpty()) {
            if (this.size == 0 || this.usedList.size() < this.size) {
                try {
                    component = this.componentFactory.createComponent();
                }
                catch (Exception e) {
                    throw new ComponentPoolException(e);
                }
            } else {
                try {
                    do {
                        this.wait(this.acquireWaitTimeMillis);
                        if (!this.freeList.isEmpty()) {
                            component = this.freeList.remove(0);
                            continue;
                        }
                        if (this.acquireWaitTimeMillis <= 0L) continue;
                        throw new ComponentPoolException("ComponentPool(%s) is completely booked", this.componentFactory.getClass().getSimpleName());
                    } while (component == null);
                }
                catch (InterruptedException i) {
                    throw new ComponentPoolException(i);
                }
            }
        } else {
            component = this.freeList.remove(0);
        }
        this.usedList.add(component);
        return component;
    }

    public synchronized void returnComponent(T component) {
        this.usedList.remove(component);
        if (this.usedList.size() + this.freeList.size() < this.size) {
            this.freeList.add(component);
            if (this.size > 0) {
                this.notify();
            }
        }
    }

    public synchronized int poolSize() {
        return this.freeList.size() + this.usedList.size();
    }

    public synchronized int freeSize() {
        return this.freeList.size();
    }
}

