/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ConnectionPoolConfig {
    private final AtomicBoolean testOnConnect = new AtomicBoolean(false);
    private final AtomicBoolean testOnAcquire = new AtomicBoolean(false);
    private final AtomicBoolean reportLeaseTimeNanos = new AtomicBoolean(false);
    private final AtomicBoolean existentiallyAware = new AtomicBoolean(false);
    private final AtomicLong connectionTimeoutMillis = new AtomicLong(0L);
    private final AtomicLong acquireWaitTimeMillis = new AtomicLong(0L);
    private final AtomicInteger initialPoolSize = new AtomicInteger(0);
    private final AtomicInteger minPoolSize = new AtomicInteger(0);
    private final AtomicInteger maxPoolSize = new AtomicInteger(10);
    private final AtomicInteger maxLeaseTimeSeconds = new AtomicInteger(0);
    private final AtomicInteger maxIdleTimeSeconds = new AtomicInteger(0);
    private final AtomicInteger unreturnedConnectionTimeoutSeconds = new AtomicInteger(0);

    public boolean requiresDeconstruction() {
        return this.getMaxLeaseTimeSeconds() > 0 || this.getMaxIdleTimeSeconds() > 0 || this.getUnreturnedConnectionTimeoutSeconds() > 0;
    }

    public boolean isTestOnConnect() {
        return this.testOnConnect.get();
    }

    public void setTestOnConnect(boolean testOnConnect) {
        this.testOnConnect.set(testOnConnect);
    }

    public boolean isTestOnAcquire() {
        return this.testOnAcquire.get();
    }

    public void setTestOnAcquire(boolean testOnAcquire) {
        this.testOnAcquire.set(testOnAcquire);
    }

    public boolean isReportLeaseTimeNanos() {
        return this.reportLeaseTimeNanos.get();
    }

    public void setReportLeaseTimeNanos(boolean reportLeaseTimeNanos) {
        this.reportLeaseTimeNanos.set(reportLeaseTimeNanos);
    }

    public boolean isExistentiallyAware() {
        return this.existentiallyAware.get();
    }

    public void setExistentiallyAware(boolean existentiallyAware) {
        this.existentiallyAware.set(existentiallyAware);
    }

    public long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis.get();
    }

    public void setConnectionTimeoutMillis(long connectionTimeoutMillis) {
        if (connectionTimeoutMillis < 0L) {
            throw new IllegalArgumentException("Connection timeout must be >= 0");
        }
        this.connectionTimeoutMillis.set(connectionTimeoutMillis);
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize.get();
    }

    public void setInitialPoolSize(int initialPoolSize) {
        if (initialPoolSize < 0) {
            throw new IllegalArgumentException("Initial pool size must be >= 0");
        }
        this.initialPoolSize.set(initialPoolSize);
    }

    public int getMinPoolSize() {
        return this.minPoolSize.get();
    }

    public void setMinPoolSize(int minPoolSize) {
        if (minPoolSize < 0) {
            throw new IllegalArgumentException("Minimum pool size must be >= 0");
        }
        this.minPoolSize.set(minPoolSize);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize.get();
    }

    public void setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 0) {
            throw new IllegalArgumentException("Maximum pool size must be >= 0");
        }
        this.maxPoolSize.set(maxPoolSize);
    }

    public long getAcquireWaitTimeMillis() {
        return this.acquireWaitTimeMillis.get();
    }

    public void setAcquireWaitTimeMillis(long acquireWaitTimeMillis) {
        if (acquireWaitTimeMillis < 0L) {
            throw new IllegalArgumentException("Acquire wait time must be >= 0");
        }
        this.acquireWaitTimeMillis.set(acquireWaitTimeMillis);
    }

    public int getMaxLeaseTimeSeconds() {
        return this.maxLeaseTimeSeconds.get();
    }

    public void setMaxLeaseTimeSeconds(int maxLeaseTimeSeconds) {
        if (maxLeaseTimeSeconds < 0) {
            throw new IllegalArgumentException("Maximum lease time must be >= 0");
        }
        this.maxLeaseTimeSeconds.set(maxLeaseTimeSeconds);
    }

    public int getMaxIdleTimeSeconds() {
        return this.maxIdleTimeSeconds.get();
    }

    public void setMaxIdleTimeSeconds(int maxIdleTimeSeconds) {
        if (maxIdleTimeSeconds < 0) {
            throw new IllegalArgumentException("Maximum idle time must be >= 0");
        }
        this.maxIdleTimeSeconds.set(maxIdleTimeSeconds);
    }

    public int getUnreturnedConnectionTimeoutSeconds() {
        return this.unreturnedConnectionTimeoutSeconds.get();
    }

    public void setUnreturnedConnectionTimeoutSeconds(int unreturnedConnectionTimeoutSeconds) {
        if (unreturnedConnectionTimeoutSeconds < 0) {
            throw new IllegalArgumentException("Unreturned connection timeout must be >= 0");
        }
        this.unreturnedConnectionTimeoutSeconds.set(unreturnedConnectionTimeoutSeconds);
    }
}

