/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.DeconstructionCoordinator;
import org.smallmind.quorum.pool.connection.DeconstructionFuse;
import org.smallmind.quorum.pool.connection.DeconstructionQueue;

public class UnreturnedConnectionTimeoutDeconstructionFuse
extends DeconstructionFuse {
    private final ConnectionPool<?> connectionPool;
    private final AtomicInteger generation = new AtomicInteger(0);
    private final AtomicInteger generationServed = new AtomicInteger(0);

    protected UnreturnedConnectionTimeoutDeconstructionFuse(ConnectionPool<?> connectionPool, DeconstructionQueue deconstructionQueue, DeconstructionCoordinator deconstructionCoordinator) {
        super(deconstructionQueue, deconstructionCoordinator);
        this.connectionPool = connectionPool;
    }

    @Override
    public boolean isPrejudicial() {
        return true;
    }

    @Override
    public synchronized void free() {
        this.generation.incrementAndGet();
        this.abort();
    }

    @Override
    public void serve() {
        this.generationServed.set(this.generation.incrementAndGet());
        this.setIgnitionTime(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.connectionPool.getConnectionPoolConfig().getUnreturnedConnectionTimeoutSeconds()));
    }

    @Override
    public synchronized void ignite() {
        if (this.generationServed.get() == this.generation.get()) {
            super.ignite();
        }
    }
}

