/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.messaging;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.transport.messaging.MessageTarget;
import org.smallmind.quorum.transport.messaging.MessagingConnectionDetails;

public class MessagingReceiver
implements MessageListener {
    private MessageTarget messageTarget;
    private QueueConnection queueConnection;
    private QueueSession queueSession;
    private QueueReceiver queueReceiver;
    private boolean stopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagingReceiver(MessageTarget messageTarget, MessagingConnectionDetails messagingConnectionDetails) throws ConnectionPoolException, NamingException, JMSException {
        QueueConnectionFactory queueConnectionFactory;
        Queue queue;
        this.messageTarget = messageTarget;
        Context javaEnvironment = (Context)messagingConnectionDetails.getContextPool().getConnection();
        try {
            queue = (Queue)javaEnvironment.lookup(messagingConnectionDetails.getDestinationName());
            queueConnectionFactory = (QueueConnectionFactory)javaEnvironment.lookup(messagingConnectionDetails.getConnectionFactoryName());
        }
        finally {
            javaEnvironment.close();
        }
        this.queueConnection = queueConnectionFactory.createQueueConnection(messagingConnectionDetails.getUserName(), messagingConnectionDetails.getPassword());
        this.queueSession = this.queueConnection.createQueueSession(false, 1);
        this.queueReceiver = messagingConnectionDetails.getServiceSelector() == null ? this.queueSession.createReceiver(queue) : this.queueSession.createReceiver(queue, "Selection='" + messagingConnectionDetails.getServiceSelector() + "'");
        this.queueReceiver.setMessageListener((MessageListener)this);
        this.queueConnection.start();
    }

    public synchronized void close() {
        this.stopped = true;
        try {
            this.queueConnection.stop();
            this.queueReceiver.close();
            this.queueSession.close();
            this.queueConnection.close();
        }
        catch (JMSException jmsException) {
            this.messageTarget.logError(jmsException);
        }
    }

    public synchronized void onMessage(Message message) {
        if (!this.stopped) {
            try {
                Message responseMessage;
                try {
                    responseMessage = this.messageTarget.handleMessage((Session)this.queueSession, message);
                }
                catch (JMSException jmsException) {
                    throw jmsException;
                }
                catch (Exception exception) {
                    responseMessage = this.queueSession.createObjectMessage((Serializable)exception);
                    responseMessage.setBooleanProperty("Exception", true);
                }
                responseMessage.setJMSDeliveryMode(1);
                QueueSender queueSender = this.queueSession.createSender((Queue)message.getJMSReplyTo());
                queueSender.send(responseMessage);
                queueSender.close();
            }
            catch (JMSException jmsException) {
                this.messageTarget.logError(jmsException);
            }
        }
    }
}

