/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.juggler;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.smallmind.quorum.juggler.BlackList;
import org.smallmind.quorum.juggler.JugglerResourceCreationException;
import org.smallmind.quorum.juggler.JugglerResourceException;
import org.smallmind.quorum.juggler.JugglingPin;
import org.smallmind.quorum.juggler.JugglingPinFactory;
import org.smallmind.quorum.juggler.NoAvailableJugglerResourceException;
import org.smallmind.scribe.pen.LoggerManager;

public class Juggler<P, R>
implements BlackList<R> {
    private final SecureRandom random = new SecureRandom();
    private final JugglingPinFactory<P, R> jugglingPinFactory;
    private final P[] providers;
    private final Class<P> managedClass;
    private final int recoveryCheckSeconds;
    private ProviderRecoveryWorker recoveryWorker = null;
    private ArrayList<JugglingPin<R>> sourcePins;
    private ArrayList<JugglingPin<R>> targetPins;
    private ConcurrentSkipListMap<Long, JugglingPin<R>> blackMap;
    private State state = State.DECONSTRUCTED;

    public Juggler(Class<P> managedClass, int recoveryCheckSeconds, JugglingPinFactory<P, R> jugglingPinFactory, P provider, int size) {
        this(managedClass, recoveryCheckSeconds, jugglingPinFactory, Juggler.generateArray(provider, size));
    }

    private static <P> P[] generateArray(P provider, int size) {
        Object[] array = new Object[size];
        Arrays.fill(array, provider);
        return array;
    }

    public Juggler(Class<P> managedClass, int recoveryCheckSeconds, JugglingPinFactory<P, R> jugglingPinFactory, P ... providers) {
        this.managedClass = managedClass;
        this.recoveryCheckSeconds = recoveryCheckSeconds;
        this.jugglingPinFactory = jugglingPinFactory;
        this.providers = providers;
    }

    public synchronized void initialize() throws JugglerResourceCreationException {
        if (this.state.equals((Object)State.DECONSTRUCTED)) {
            this.sourcePins = new ArrayList(this.providers.length);
            this.targetPins = new ArrayList(this.providers.length);
            this.blackMap = new ConcurrentSkipListMap();
            for (P provider : this.providers) {
                this.targetPins.add(this.jugglingPinFactory.createJugglingPin(this, provider));
            }
            while (!this.targetPins.isEmpty()) {
                this.sourcePins.add(this.targetPins.remove(this.random.nextInt(this.targetPins.size())));
            }
            this.state = State.INITIALIZED;
        }
    }

    public synchronized void startup() throws JugglerResourceException {
        if (this.state.equals((Object)State.INITIALIZED)) {
            for (JugglingPin<R> pin : this.sourcePins) {
                pin.start();
            }
            if (this.recoveryCheckSeconds > 0) {
                this.recoveryWorker = new ProviderRecoveryWorker(this.recoveryCheckSeconds);
                Thread recoveryThread = new Thread(this.recoveryWorker);
                recoveryThread.setDaemon(true);
                recoveryThread.start();
            }
            this.state = State.STARTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized R pickResource() throws NoAvailableJugglerResourceException {
        if (!this.state.equals((Object)State.INITIALIZED) && !this.state.equals((Object)State.STARTED)) {
            throw new IllegalStateException("Juggler must be in the initialized or started state");
        }
        while (!this.sourcePins.isEmpty() || !this.targetPins.isEmpty()) {
            if (this.sourcePins.isEmpty()) {
                ArrayList<JugglingPin<R>> tempPins = this.sourcePins;
                this.sourcePins = this.targetPins;
                this.targetPins = tempPins;
            }
            JugglingPin<R> pin = this.sourcePins.remove(this.random.nextInt(this.sourcePins.size()));
            try {
                R resource = pin.obtain();
                this.targetPins.add(pin);
                return resource;
            }
            catch (Exception exception) {
                try {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                }
                finally {
                    this.blackMap.put(System.currentTimeMillis(), pin);
                }
            }
        }
        throw new NoAvailableJugglerResourceException("All available resources(%s) have been black listed", this.managedClass.getSimpleName());
    }

    @Override
    public synchronized void addToBlackList(JugglingPin<R> blackPin) {
        if (this.sourcePins.remove(blackPin)) {
            this.blackMap.put(System.currentTimeMillis(), blackPin);
        } else if (this.targetPins.remove(blackPin)) {
            this.blackMap.put(System.currentTimeMillis(), blackPin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.state.equals((Object)State.STARTED)) {
            if (this.recoveryWorker != null) {
                try {
                    this.recoveryWorker.abort();
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)interruptedException);
                }
            }
            for (JugglingPin<R> pin : this.sourcePins) {
                try {
                    pin.stop();
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                }
            }
            while (!this.targetPins.isEmpty()) {
                JugglingPin<R> pin = this.targetPins.remove(0);
                try {
                    pin.stop();
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                }
                finally {
                    this.sourcePins.add(pin);
                }
            }
            this.state = State.STOPPED;
        }
    }

    public synchronized void deconstruct() {
        if (this.state.equals((Object)State.STOPPED)) {
            for (JugglingPin<R> pin : this.sourcePins) {
                try {
                    pin.close();
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                }
            }
            this.state = State.DECONSTRUCTED;
        }
    }

    private class ProviderRecoveryWorker
    implements Runnable {
        private CountDownLatch terminationLatch = new CountDownLatch(1);
        private CountDownLatch exitLatch = new CountDownLatch(1);
        private long recoveryCheckMillis;

        public ProviderRecoveryWorker(int recoveryCheckSeconds) {
            this.recoveryCheckMillis = recoveryCheckSeconds * 1000;
        }

        public void abort() throws InterruptedException {
            this.terminationLatch.countDown();
            this.exitLatch.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.terminationLatch.await(3L, TimeUnit.SECONDS)) {
                    Map.Entry firstEntry;
                    while ((firstEntry = Juggler.this.blackMap.firstEntry()) != null && (Long)firstEntry.getKey() + this.recoveryCheckMillis <= System.currentTimeMillis()) {
                        if (!((JugglingPin)firstEntry.getValue()).recover()) continue;
                        Juggler juggler = Juggler.this;
                        synchronized (juggler) {
                            JugglingPin recoveredPin = (JugglingPin)Juggler.this.blackMap.remove(firstEntry.getKey());
                            if (recoveredPin != null) {
                                Juggler.this.targetPins.add(recoveredPin);
                            } else {
                                LoggerManager.getLogger(ProviderRecoveryWorker.class).fatal("We've lost a resource(%s), which should never occur - please notify a system administrator", new Object[]{Juggler.this.managedClass.getSimpleName()});
                            }
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LoggerManager.getLogger(ProviderRecoveryWorker.class).error((Throwable)interruptedException);
            }
            this.exitLatch.countDown();
        }
    }

    private static enum State {
        DECONSTRUCTED,
        INITIALIZED,
        STARTED,
        STOPPED;

    }
}

