/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PoolConfig<P extends PoolConfig> {
    private final AtomicBoolean reportLeaseTimeNanos = new AtomicBoolean(false);
    private final AtomicBoolean existentiallyAware = new AtomicBoolean(false);
    private final AtomicLong acquireWaitTimeMillis = new AtomicLong(0L);
    private final AtomicInteger initialPoolSize = new AtomicInteger(0);
    private final AtomicInteger minPoolSize = new AtomicInteger(0);
    private final AtomicInteger maxPoolSize = new AtomicInteger(10);
    private final AtomicInteger maxLeaseTimeSeconds = new AtomicInteger(0);
    private final AtomicInteger maxIdleTimeSeconds = new AtomicInteger(0);
    private final AtomicInteger unReturnedElementTimeoutSeconds = new AtomicInteger(0);

    public PoolConfig() {
    }

    public PoolConfig(PoolConfig<?> poolConfig) {
        this.setReportLeaseTimeNanos(poolConfig.isReportLeaseTimeNanos());
        this.setExistentiallyAware(poolConfig.isExistentiallyAware());
        this.setAcquireWaitTimeMillis(poolConfig.getAcquireWaitTimeMillis());
        this.setInitialPoolSize(poolConfig.getInitialPoolSize());
        this.setMinPoolSize(poolConfig.getMinPoolSize());
        this.setMaxPoolSize(poolConfig.getMaxPoolSize());
        this.setMaxLeaseTimeSeconds(poolConfig.getMaxLeaseTimeSeconds());
        this.setMaxIdleTimeSeconds(poolConfig.getMaxIdleTimeSeconds());
        this.setUnReturnedElementTimeoutSeconds(poolConfig.getUnReturnedElementTimeoutSeconds());
    }

    public abstract Class<P> getConfigurationClass();

    public boolean isReportLeaseTimeNanos() {
        return this.reportLeaseTimeNanos.get();
    }

    public P setReportLeaseTimeNanos(boolean reportLeaseTimeNanos) {
        this.reportLeaseTimeNanos.set(reportLeaseTimeNanos);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public boolean isExistentiallyAware() {
        return this.existentiallyAware.get();
    }

    public P setExistentiallyAware(boolean existentiallyAware) {
        this.existentiallyAware.set(existentiallyAware);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize.get();
    }

    public P setInitialPoolSize(int initialPoolSize) {
        if (initialPoolSize < 0) {
            throw new IllegalArgumentException("Initial pool size must be >= 0");
        }
        this.initialPoolSize.set(initialPoolSize);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public int getMinPoolSize() {
        return this.minPoolSize.get();
    }

    public P setMinPoolSize(int minPoolSize) {
        if (minPoolSize < 0) {
            throw new IllegalArgumentException("Minimum pool size must be >= 0");
        }
        this.minPoolSize.set(minPoolSize);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize.get();
    }

    public P setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 0) {
            throw new IllegalArgumentException("Maximum pool size must be >= 0");
        }
        this.maxPoolSize.set(maxPoolSize);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public long getAcquireWaitTimeMillis() {
        return this.acquireWaitTimeMillis.get();
    }

    public P setAcquireWaitTimeMillis(long acquireWaitTimeMillis) {
        if (acquireWaitTimeMillis < 0L) {
            throw new IllegalArgumentException("Acquire wait time must be >= 0");
        }
        this.acquireWaitTimeMillis.set(acquireWaitTimeMillis);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public int getMaxLeaseTimeSeconds() {
        return this.maxLeaseTimeSeconds.get();
    }

    public P setMaxLeaseTimeSeconds(int maxLeaseTimeSeconds) {
        if (maxLeaseTimeSeconds < 0) {
            throw new IllegalArgumentException("Maximum lease time must be >= 0");
        }
        this.maxLeaseTimeSeconds.set(maxLeaseTimeSeconds);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public int getMaxIdleTimeSeconds() {
        return this.maxIdleTimeSeconds.get();
    }

    public P setMaxIdleTimeSeconds(int maxIdleTimeSeconds) {
        if (maxIdleTimeSeconds < 0) {
            throw new IllegalArgumentException("Maximum idle time must be >= 0");
        }
        this.maxIdleTimeSeconds.set(maxIdleTimeSeconds);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public int getUnReturnedElementTimeoutSeconds() {
        return this.unReturnedElementTimeoutSeconds.get();
    }

    public P setUnReturnedElementTimeoutSeconds(int unReturnedElementTimeoutSeconds) {
        if (unReturnedElementTimeoutSeconds < 0) {
            throw new IllegalArgumentException("Un-returned element timeout must be >= 0");
        }
        this.unReturnedElementTimeoutSeconds.set(unReturnedElementTimeoutSeconds);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }
}

