/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.component;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.quorum.pool.component.ComponentFactory;
import org.smallmind.quorum.pool.component.ComponentPoolException;
import org.smallmind.quorum.pool.component.PooledComponent;

public class ComponentPool<T extends PooledComponent> {
    private CountDownLatch exitLatch = new CountDownLatch(1);
    private CountDownLatch terminationLatch = new CountDownLatch(1);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private ComponentFactory<T> componentFactory;
    private LinkedList<T> usedList;
    private LinkedList<T> freeList;
    private long acquireWaitTimeMillis;
    private int size;

    public ComponentPool(ComponentFactory<T> componentFactory, int size, long acquireWaitTimeMillis) {
        this.componentFactory = componentFactory;
        this.size = size;
        this.acquireWaitTimeMillis = acquireWaitTimeMillis;
        this.usedList = new LinkedList();
        this.freeList = new LinkedList();
    }

    public synchronized T getComponent() throws ComponentPoolException {
        if (this.closed.get()) {
            throw new ComponentPoolException("Pool has been closed", new Object[0]);
        }
        PooledComponent component = null;
        if (this.freeList.isEmpty()) {
            if (this.size == 0 || this.usedList.size() < this.size) {
                try {
                    component = this.componentFactory.createComponent();
                }
                catch (Exception e) {
                    throw new ComponentPoolException(e);
                }
            } else {
                try {
                    do {
                        this.wait(this.acquireWaitTimeMillis);
                        if (this.closed.get()) {
                            throw new ComponentPoolException("Pool has been closed", new Object[0]);
                        }
                        if (!this.freeList.isEmpty()) {
                            component = (PooledComponent)this.freeList.removeFirst();
                            continue;
                        }
                        if (this.acquireWaitTimeMillis <= 0L) continue;
                        throw new ComponentPoolException("ComponentPool(%s) is completely booked", this.componentFactory.getClass().getSimpleName());
                    } while (component == null);
                }
                catch (InterruptedException i) {
                    throw new ComponentPoolException(i);
                }
            }
        } else {
            component = (PooledComponent)this.freeList.removeFirst();
        }
        this.usedList.add(component);
        return (T)component;
    }

    public synchronized void returnComponent(T component) {
        this.usedList.remove(component);
        if (this.usedList.size() + this.freeList.size() < this.size) {
            this.freeList.add(component);
            if (this.size > 0) {
                this.notify();
            }
        } else {
            component.terminate();
        }
        if (this.closed.get() && this.usedList.isEmpty()) {
            this.terminationLatch.countDown();
        }
    }

    public synchronized int poolSize() {
        return this.freeList.size() + this.usedList.size();
    }

    public synchronized int freeSize() {
        return this.freeList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                ComponentPool componentPool = this;
                synchronized (componentPool) {
                    this.notifyAll();
                    if (this.usedList.isEmpty()) {
                        this.terminationLatch.countDown();
                    }
                }
                this.terminationLatch.await();
                for (PooledComponent component : this.freeList) {
                    component.terminate();
                }
            }
            finally {
                this.exitLatch.countDown();
            }
        }
        this.exitLatch.await();
    }
}

