/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.smallmind.nutsnbolts.lang.StackTrace;
import org.smallmind.quorum.pool.connection.ConnectionInstance;
import org.smallmind.quorum.pool.connection.ConnectionInstanceFactory;
import org.smallmind.quorum.pool.connection.ConnectionPin;
import org.smallmind.quorum.pool.connection.ConnectionPinManager;
import org.smallmind.quorum.pool.connection.ConnectionPoolConfig;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.pool.connection.event.ConnectionPoolEventListener;
import org.smallmind.quorum.pool.connection.event.ErrorReportingConnectionPoolEvent;
import org.smallmind.quorum.pool.connection.event.LeaseTimeReportingConnectionPoolEvent;

public class ConnectionPool<C> {
    private final ConcurrentLinkedQueue<ConnectionPoolEventListener> connectionPoolEventListenerQueue = new ConcurrentLinkedQueue();
    private final ConnectionInstanceFactory<?, C> connectionInstanceFactory;
    private final ConnectionPinManager<C> connectionPinManager;
    private final String name;
    private ConnectionPoolConfig connectionPoolConfig = new ConnectionPoolConfig();

    public ConnectionPool(String name, ConnectionInstanceFactory<?, C> connectionInstanceFactory) {
        this.name = name;
        this.connectionInstanceFactory = connectionInstanceFactory;
        this.connectionPinManager = new ConnectionPinManager(this);
    }

    public ConnectionPool(String name, ConnectionInstanceFactory<?, C> connectionInstanceFactory, ConnectionPoolConfig connectionPoolConfig) {
        this(name, connectionInstanceFactory);
        this.connectionPoolConfig = connectionPoolConfig;
    }

    public String getPoolName() {
        return this.name;
    }

    public ConnectionInstanceFactory<?, C> getConnectionInstanceFactory() {
        return this.connectionInstanceFactory;
    }

    public ConnectionPoolConfig getConnectionPoolConfig() {
        return this.connectionPoolConfig;
    }

    public ConnectionPool<C> setConnectionPoolConfig(ConnectionPoolConfig connectionPoolConfig) {
        this.connectionPoolConfig = connectionPoolConfig;
        return this;
    }

    public StackTrace[] getExistentialStackTraces() {
        return this.connectionPinManager.getExistentialStackTraces();
    }

    public void addConnectionPoolEventListener(ConnectionPoolEventListener listener) {
        this.connectionPoolEventListenerQueue.add(listener);
    }

    public void removeConnectionPoolEventListener(ConnectionPoolEventListener listener) {
        this.connectionPoolEventListenerQueue.remove(listener);
    }

    public void reportConnectionErrorOccurred(Exception exception) {
        ErrorReportingConnectionPoolEvent poolEvent = new ErrorReportingConnectionPoolEvent(this, exception);
        for (ConnectionPoolEventListener listener : this.connectionPoolEventListenerQueue) {
            listener.reportConnectionErrorOccurred(poolEvent);
        }
    }

    public void reportConnectionLeaseTimeNanos(long leaseTimeNanos) {
        LeaseTimeReportingConnectionPoolEvent poolEvent = new LeaseTimeReportingConnectionPoolEvent(this, leaseTimeNanos);
        for (ConnectionPoolEventListener listener : this.connectionPoolEventListenerQueue) {
            listener.reportConnectionLeaseTime(poolEvent);
        }
    }

    public void startup() throws ConnectionPoolException {
        try {
            this.connectionInstanceFactory.initialize();
        }
        catch (Exception exception) {
            throw new ConnectionPoolException(exception);
        }
        this.connectionPinManager.startup();
        try {
            this.connectionInstanceFactory.startup();
        }
        catch (Exception exception) {
            throw new ConnectionPoolException(exception);
        }
    }

    public void shutdown() throws ConnectionPoolException {
        try {
            this.connectionInstanceFactory.shutdown();
        }
        catch (Exception exception) {
            throw new ConnectionPoolException(exception);
        }
        this.connectionPinManager.shutdown();
        try {
            this.connectionInstanceFactory.deconstruct();
        }
        catch (Exception exception) {
            throw new ConnectionPoolException(exception);
        }
    }

    public C getConnection() throws ConnectionPoolException {
        try {
            return this.connectionPinManager.serve().serve();
        }
        catch (Exception exception) {
            throw new ConnectionPoolException(exception);
        }
    }

    public void returnInstance(ConnectionInstance<C> connectionInstance) {
        this.connectionPinManager.process(connectionInstance);
    }

    public void terminateInstance(ConnectionInstance<C> connectionInstance) {
        this.connectionPinManager.terminate(connectionInstance);
    }

    public void removePin(ConnectionPin<C> connectionPin, boolean withPrejudice) {
        this.connectionPinManager.remove(connectionPin, withPrejudice);
    }

    public int getPoolSize() {
        return this.connectionPinManager.getPoolSize();
    }

    public int getFreeSize() {
        return this.connectionPinManager.getFreeSize();
    }

    public int getProcessingSize() {
        return this.connectionPinManager.getProcessingSize();
    }
}

