/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.smallmind.quorum.pool.PoolConfig;

public class ConnectionPoolConfig
extends PoolConfig<ConnectionPoolConfig> {
    private final AtomicBoolean testOnConnect = new AtomicBoolean(false);
    private final AtomicBoolean testOnAcquire = new AtomicBoolean(false);
    private final AtomicLong connectionTimeoutMillis = new AtomicLong(0L);

    public ConnectionPoolConfig() {
    }

    public ConnectionPoolConfig(PoolConfig<?> poolConfig) {
        super(poolConfig);
        if (poolConfig.getConfigurationClass().isAssignableFrom(ConnectionPoolConfig.class)) {
            this.setTestOnConnect(((ConnectionPoolConfig)poolConfig).isTestOnConnect());
            this.setTestOnAcquire(((ConnectionPoolConfig)poolConfig).isTestOnAcquire());
            this.setConnectionTimeoutMillis(((ConnectionPoolConfig)poolConfig).getConnectionTimeoutMillis());
        }
    }

    @Override
    public Class<ConnectionPoolConfig> getConfigurationClass() {
        return ConnectionPoolConfig.class;
    }

    public boolean requiresDeconstruction() {
        return this.getMaxLeaseTimeSeconds() > 0 || this.getMaxIdleTimeSeconds() > 0 || this.getUnReturnedElementTimeoutSeconds() > 0;
    }

    public boolean isTestOnConnect() {
        return this.testOnConnect.get();
    }

    public ConnectionPoolConfig setTestOnConnect(boolean testOnConnect) {
        this.testOnConnect.set(testOnConnect);
        return this.getConfigurationClass().cast(this);
    }

    public boolean isTestOnAcquire() {
        return this.testOnAcquire.get();
    }

    public ConnectionPoolConfig setTestOnAcquire(boolean testOnAcquire) {
        this.testOnAcquire.set(testOnAcquire);
        return this.getConfigurationClass().cast(this);
    }

    public long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis.get();
    }

    public ConnectionPoolConfig setConnectionTimeoutMillis(long connectionTimeoutMillis) {
        if (connectionTimeoutMillis < 0L) {
            throw new IllegalArgumentException("Connection timeout must be >= 0");
        }
        this.connectionTimeoutMillis.set(connectionTimeoutMillis);
        return this.getConfigurationClass().cast(this);
    }
}

