/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.io.Serializable;
import javax.jms.Message;
import javax.jms.Session;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.MethodInvoker;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.MessageTarget;

public class InvocationMessageTarget
implements MessageTarget {
    private MethodInvoker methodInvoker;
    private Class serviceInterface;

    public InvocationMessageTarget(Object targetObject, Class serviceInterface) throws NoSuchMethodException {
        this.serviceInterface = serviceInterface;
        this.methodInvoker = new MethodInvoker(targetObject, new Class[]{this.serviceInterface});
    }

    @Override
    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    @Override
    public Message handleMessage(Session session, MessageStrategy messageStrategy, Message message) throws Exception {
        InvocationSignal invocationSignal = (InvocationSignal)messageStrategy.unwrapFromMessage(message);
        Serializable result = (Serializable)this.methodInvoker.remoteInvocation(invocationSignal);
        return messageStrategy.wrapInMessage(session, result);
    }
}

