/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.smallmind.quorum.transport.message.MessagePolicy;

public class QueueOperator {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final QueueSession requestSession;
    private final QueueSender requestSender;

    public QueueOperator(QueueConnection requestConnection, Queue requestQueue, MessagePolicy messagePolicy) throws JMSException {
        this.requestSession = requestConnection.createQueueSession(false, messagePolicy.getAcknowledgeMode().getJmsValue());
        this.requestSender = this.requestSession.createSender(requestQueue);
        messagePolicy.apply((MessageProducer)this.requestSender);
    }

    public QueueSession getRequestSession() {
        return this.requestSession;
    }

    public void send(Message message) throws JMSException {
        this.requestSender.send(message);
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.requestSender.close();
            this.requestSession.close();
        }
    }
}

