/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import org.smallmind.quorum.transport.message.AcknowledgeMode;
import org.smallmind.scribe.pen.LoggerManager;

public class ReceptionListener
implements MessageListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final QueueConnection requestConnection;
    private final QueueSession requestSession;
    private final QueueReceiver requestReceiver;
    private final SynchronousQueue<Message> messageRendezvous;

    public ReceptionListener(QueueConnection requestConnection, Queue requestQueue, AcknowledgeMode acknowledgeMode, SynchronousQueue<Message> messageRendezvous) throws JMSException {
        this.requestConnection = requestConnection;
        this.messageRendezvous = messageRendezvous;
        this.requestSession = requestConnection.createQueueSession(false, acknowledgeMode.getJmsValue());
        this.requestReceiver = this.requestSession.createReceiver(requestQueue);
        this.requestReceiver.setMessageListener((MessageListener)this);
        requestConnection.start();
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.requestConnection.stop();
            this.requestReceiver.close();
            this.requestSession.close();
            this.requestConnection.close();
        }
    }

    public synchronized void onMessage(Message message) {
        try {
            boolean success;
            do {
                success = this.messageRendezvous.offer(message, 1L, TimeUnit.SECONDS);
            } while (!this.closed.get() && !success);
        }
        catch (InterruptedException interruptedException) {
            LoggerManager.getLogger(ReceptionListener.class).error((Throwable)interruptedException);
        }
    }
}

