/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Message;
import javax.jms.Session;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.MessageTarget;
import org.smallmind.quorum.transport.message.TopicOperator;
import org.smallmind.scribe.pen.LoggerManager;

public class ReceptionWorker
implements Runnable {
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final CountDownLatch exitLatch = new CountDownLatch(1);
    private final MessageStrategy messageStrategy;
    private final Map<String, MessageTarget> targetMap;
    private final SynchronousQueue<Message> messageRendezvous;
    private final ConcurrentLinkedQueue<TopicOperator> operatorQueue;

    public ReceptionWorker(MessageStrategy messageStrategy, Map<String, MessageTarget> targetMap, SynchronousQueue<Message> messageRendezvous, ConcurrentLinkedQueue<TopicOperator> operatorQueue) {
        this.messageStrategy = messageStrategy;
        this.targetMap = targetMap;
        this.messageRendezvous = messageRendezvous;
        this.operatorQueue = operatorQueue;
    }

    public void stop() throws InterruptedException {
        this.stopped.set(true);
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stopped.get()) {
                Message requestMessage = this.messageRendezvous.poll(1L, TimeUnit.SECONDS);
                if (requestMessage == null) continue;
                TopicOperator topicOperator = this.operatorQueue.poll();
                if (topicOperator == null) {
                    throw new TransportException("Unable to take a TopicOperator, which should never happen - please contact your system administrator", new Object[0]);
                }
                try {
                    Message responseMessage;
                    String transmissionInstance = requestMessage.getStringProperty(MessageProperty.INSTANCE.getKey());
                    if (transmissionInstance == null) {
                        throw new TransportException("Missing message property(%s)", MessageProperty.INSTANCE.getKey());
                    }
                    try {
                        String serviceSelector = requestMessage.getStringProperty(MessageProperty.SERVICE.getKey());
                        if (serviceSelector == null) {
                            throw new TransportException("Missing message property(%s)", MessageProperty.SERVICE.getKey());
                        }
                        MessageTarget messageTarget = this.targetMap.get(serviceSelector);
                        if (messageTarget == null) {
                            throw new TransportException("Unknown service selector(%s)", serviceSelector);
                        }
                        responseMessage = messageTarget.handleMessage((Session)topicOperator.getResponseSession(), this.messageStrategy, requestMessage);
                    }
                    catch (Exception exception) {
                        responseMessage = this.messageStrategy.wrapInMessage((Session)topicOperator.getResponseSession(), exception);
                        responseMessage.setBooleanProperty(MessageProperty.EXCEPTION.getKey(), true);
                    }
                    responseMessage.setJMSCorrelationID(requestMessage.getJMSMessageID());
                    responseMessage.setStringProperty(MessageProperty.INSTANCE.getKey(), transmissionInstance);
                    topicOperator.publish(responseMessage);
                }
                catch (Throwable throwable) {
                    LoggerManager.getLogger(ReceptionWorker.class).error(throwable);
                }
                finally {
                    this.operatorQueue.add(topicOperator);
                }
            }
        }
        catch (Exception exception) {
            LoggerManager.getLogger(ReceptionWorker.class).error((Throwable)exception);
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

