/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.smallmind.quorum.transport.message.SelfDestructive;
import org.smallmind.quorum.transport.message.SelfDestructiveKey;
import org.smallmind.scribe.pen.LoggerManager;

public class SelfDestructiveMap<K extends Comparable<K>, V extends SelfDestructive> {
    private final ConcurrentHashMap<K, V> internalMap = new ConcurrentHashMap();
    private final ConcurrentSkipListSet<SelfDestructiveKey<K>> ignitionKeySet = new ConcurrentSkipListSet();
    private IgnitionWorker ignitionWorker;
    private final int timeoutSeconds;

    public SelfDestructiveMap(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        this.ignitionWorker = new IgnitionWorker();
        Thread ignitionThread = new Thread(this.ignitionWorker);
        ignitionThread.setDaemon(true);
        ignitionThread.start();
    }

    public V get(K key) {
        return (V)((SelfDestructive)this.internalMap.get(key));
    }

    public V putIfAbsent(K key, V value) {
        SelfDestructive previousValue = (SelfDestructive)this.internalMap.putIfAbsent(key, value);
        if (previousValue == null) {
            this.ignitionKeySet.add(new SelfDestructiveKey<K>(key, System.currentTimeMillis() + (long)(this.timeoutSeconds * 1000)));
        }
        return (V)previousValue;
    }

    public V remove(K key) {
        return (V)((SelfDestructive)this.internalMap.remove(key));
    }

    public void shutdown() throws InterruptedException {
        this.ignitionWorker.shutdown();
    }

    private class IgnitionWorker
    implements Runnable {
        private final CountDownLatch terminationLatch = new CountDownLatch(1);
        private final CountDownLatch exitLatch = new CountDownLatch(1);

        private IgnitionWorker() {
        }

        public void shutdown() throws InterruptedException {
            this.terminationLatch.countDown();
            this.exitLatch.await();
        }

        @Override
        public void run() {
            try {
                while (!this.terminationLatch.await(1L, TimeUnit.SECONDS)) {
                    SelfDestructiveKey ignitedKey;
                    long now = System.currentTimeMillis();
                    SortedSet ignitedKeySet = SelfDestructiveMap.this.ignitionKeySet.headSet(new SelfDestructiveKey(now));
                    if (ignitedKeySet.isEmpty()) continue;
                    while ((ignitedKey = (SelfDestructiveKey)ignitedKeySet.pollFirst()) != null) {
                        SelfDestructive selfDestructive = (SelfDestructive)SelfDestructiveMap.this.internalMap.remove(ignitedKey.getMapKey());
                        if (selfDestructive == null) continue;
                        selfDestructive.destroy();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LoggerManager.getLogger(SelfDestructiveMap.class).error((Throwable)interruptedException);
            }
            this.exitLatch.countDown();
        }
    }
}

