/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.smallmind.quorum.transport.message.MessagePolicy;

public class TopicOperator {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final TopicSession responseSession;
    private final TopicPublisher responsePublisher;

    public TopicOperator(TopicConnection responseConnection, Topic responseTopic, MessagePolicy messagePolicy) throws JMSException {
        this.responseSession = responseConnection.createTopicSession(false, messagePolicy.getAcknowledgeMode().getJmsValue());
        this.responsePublisher = this.responseSession.createPublisher(responseTopic);
        messagePolicy.apply((MessageProducer)this.responsePublisher);
    }

    public TopicSession getResponseSession() {
        return this.responseSession;
    }

    public void publish(Message message) throws JMSException {
        this.responsePublisher.publish(message);
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.responsePublisher.close();
            this.responseSession.close();
        }
    }
}

