/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.cache.indigenous;

import org.smallmind.quorum.cache.indigenous.AbstractTimestampOrderedCacheEntry;
import org.smallmind.quorum.cache.indigenous.CacheExpirationPolicy;

public class TimeToLiveCacheExpirationPolicy<E extends AbstractTimestampOrderedCacheEntry<?>>
implements CacheExpirationPolicy<E> {
    private int timeToLiveSeconds;
    private int timerTickSeconds;

    public TimeToLiveCacheExpirationPolicy(int timeToLiveSeconds) {
        this(timeToLiveSeconds, 0);
    }

    public TimeToLiveCacheExpirationPolicy(int timeToLiveSeconds, int timerTickSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timerTickSeconds = timerTickSeconds;
    }

    @Override
    public int getTimerTickSeconds() {
        return this.timerTickSeconds;
    }

    @Override
    public boolean isStale(E cacheEntry) {
        return ((AbstractTimestampOrderedCacheEntry)cacheEntry).getCacheMetaData().getLastAccessTimestamp() - ((AbstractTimestampOrderedCacheEntry)cacheEntry).getCacheMetaData().getCreationTimestamp() > (long)(this.timeToLiveSeconds * 1000);
    }
}

