/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.quorum.pool.connection.ConnectionInstance;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.DeconstructionCoordinator;
import org.smallmind.quorum.pool.connection.DeconstructionQueue;

public class ConnectionPin<C> {
    private final ConnectionPool<C> connectionPool;
    private final ConnectionInstance<C> connectionInstance;
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private DeconstructionCoordinator deconstructionCoordinator;
    private long leaseStartNanos;

    protected ConnectionPin(ConnectionPool<C> connectionPool, DeconstructionQueue deconstructionQueue, ConnectionInstance<C> connectionInstance) {
        this.connectionPool = connectionPool;
        this.connectionInstance = connectionInstance;
        if (connectionPool.getConnectionPoolConfig().requiresDeconstruction()) {
            this.deconstructionCoordinator = new DeconstructionCoordinator(connectionPool, deconstructionQueue, this);
            this.deconstructionCoordinator.free();
        }
    }

    protected ConnectionInstance<C> getConnectionInstance() {
        return this.connectionInstance;
    }

    protected C serve() throws Exception {
        try {
            C c = this.connectionInstance.serve();
            return c;
        }
        finally {
            if (this.deconstructionCoordinator != null) {
                this.deconstructionCoordinator.serve();
            }
            if (this.connectionPool.getConnectionPoolConfig().isReportLeaseTimeNanos()) {
                this.leaseStartNanos = System.nanoTime();
            }
        }
    }

    protected void free() {
        if (this.connectionPool.getConnectionPoolConfig().isReportLeaseTimeNanos()) {
            this.connectionPool.reportConnectionLeaseTimeNanos(System.nanoTime() - this.leaseStartNanos);
        }
        if (this.deconstructionCoordinator != null) {
            this.deconstructionCoordinator.free();
        }
    }

    protected boolean isTerminated() {
        return this.terminated.get();
    }

    protected void fizzle() {
        if (this.terminated.compareAndSet(false, true) && this.deconstructionCoordinator != null) {
            this.deconstructionCoordinator.abort();
        }
    }

    protected void kaboom(boolean withPrejudice) {
        if (this.terminated.compareAndSet(false, true)) {
            this.connectionPool.removePin(this, withPrejudice);
        }
    }

    public StackTraceElement[] getExistentialStackTrace() {
        return this.connectionInstance.getExistentialStackTrace();
    }
}

