/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.nutsnbolts.lang.StackTrace;
import org.smallmind.quorum.pool.connection.ConnectionCreationException;
import org.smallmind.quorum.pool.connection.ConnectionInstance;
import org.smallmind.quorum.pool.connection.ConnectionPin;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.pool.connection.ConnectionValidationException;
import org.smallmind.quorum.pool.connection.ConnectionWorker;
import org.smallmind.quorum.pool.connection.DeconstructionQueue;
import org.smallmind.scribe.pen.LoggerManager;

public class ConnectionPinManager<C> {
    private final ConnectionPool<C> connectionPool;
    private final HashMap<ConnectionInstance<C>, ConnectionPin<C>> backingMap = new HashMap();
    private final LinkedBlockingQueue<ConnectionPin<C>> freeQueue = new LinkedBlockingQueue();
    private final ReentrantReadWriteLock backingLock = new ReentrantReadWriteLock();
    private final DeconstructionQueue deconstructionQueue = new DeconstructionQueue();
    private final AtomicReference<State> stateRef = new AtomicReference<State>(State.STOPPED);
    private final AtomicInteger size = new AtomicInteger(0);

    public ConnectionPinManager(ConnectionPool<C> connectionPool) {
        this.connectionPool = connectionPool;
    }

    /*
     * Exception decompiling
     */
    public void startup() throws ConnectionPoolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ConnectionPin<C> serve() throws ConnectionPoolException {
        if (!State.STARTED.equals((Object)this.stateRef.get())) {
            throw new ConnectionPoolException("ConnectionPool is not in the 'started' state", new Object[0]);
        }
        ConnectionPin<C> connectionPin = this.freeQueue.poll();
        if (connectionPin != null) {
            if (this.connectionPool.getConnectionPoolConfig().isTestOnAcquire() && !connectionPin.getConnectionInstance().validate()) {
                throw new ConnectionValidationException("A free connection was acquired, but failed to validate", new Object[0]);
            }
            return connectionPin;
        }
        connectionPin = this.addConnectionPin(true);
        if (connectionPin != null) {
            return connectionPin;
        }
        try {
            if (this.connectionPool.getConnectionPoolConfig().getAcquireWaitTimeMillis() > 0L && (connectionPin = this.freeQueue.poll(this.connectionPool.getConnectionPoolConfig().getAcquireWaitTimeMillis(), TimeUnit.MILLISECONDS)) != null) {
                if (this.connectionPool.getConnectionPoolConfig().isTestOnAcquire() && !connectionPin.getConnectionInstance().validate()) {
                    throw new ConnectionValidationException("A free connection was acquired, but failed to validate", new Object[0]);
                }
                return connectionPin;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ConnectionPoolException(interruptedException);
        }
        throw new ConnectionPoolException("Exceeded the maximum acquire wait time(%d)", this.connectionPool.getConnectionPoolConfig().getAcquireWaitTimeMillis());
    }

    private ConnectionPin<C> addConnectionPin(boolean forced) throws ConnectionCreationException, ConnectionValidationException {
        if (State.STARTED.equals((Object)this.stateRef.get())) {
            int minPoolSize = this.connectionPool.getConnectionPoolConfig().getMinPoolSize();
            int maxPoolSize = this.connectionPool.getConnectionPoolConfig().getMaxPoolSize();
            int currentSize = this.size.get();
            if (!(!forced && currentSize <= minPoolSize || maxPoolSize != 0 && currentSize >= maxPoolSize)) {
                this.backingLock.writeLock().lock();
                try {
                    currentSize = this.size.get();
                    if (!(!forced && currentSize <= minPoolSize || maxPoolSize != 0 && currentSize >= maxPoolSize)) {
                        ConnectionInstance<C> connectionInstance = this.manufactureConnectionInstance();
                        ConnectionPin<C> connectionPin = new ConnectionPin<C>(this.connectionPool, this.deconstructionQueue, connectionInstance);
                        this.backingMap.put(connectionInstance, connectionPin);
                        this.size.incrementAndGet();
                        ConnectionPin<C> connectionPin2 = connectionPin;
                        return connectionPin2;
                    }
                }
                finally {
                    this.backingLock.writeLock().unlock();
                }
            }
        }
        return null;
    }

    private ConnectionInstance<C> manufactureConnectionInstance() throws ConnectionCreationException, ConnectionValidationException {
        ConnectionInstance<C> connectionInstance;
        try {
            if (this.connectionPool.getConnectionPoolConfig().getConnectionTimeoutMillis() > 0L) {
                ConnectionWorker<C> connectionWorker = new ConnectionWorker<C>(this.connectionPool);
                Thread workerThread = new Thread(connectionWorker);
                workerThread.setDaemon(true);
                workerThread.start();
                workerThread.join(this.connectionPool.getConnectionPoolConfig().getConnectionTimeoutMillis());
                if (connectionWorker.abort()) {
                    throw new ConnectionCreationException("Exceeded connection timeout(%d) waiting on connection creation", this.connectionPool.getConnectionPoolConfig().getConnectionTimeoutMillis());
                }
                connectionInstance = connectionWorker.getConnectionInstance();
            } else {
                connectionInstance = this.connectionPool.getConnectionInstanceFactory().createInstance(this.connectionPool);
            }
        }
        catch (ConnectionCreationException connectionCreationException) {
            throw connectionCreationException;
        }
        catch (Exception exception) {
            throw new ConnectionCreationException(exception);
        }
        if (this.connectionPool.getConnectionPoolConfig().isTestOnConnect() && !connectionInstance.validate()) {
            throw new ConnectionValidationException("A new connection was required, but failed to validate", new Object[0]);
        }
        return connectionInstance;
    }

    public void remove(ConnectionPin<C> connectionPin, boolean withPrejudice) {
        if (this.freeQueue.remove(connectionPin) || withPrejudice) {
            this.terminate(connectionPin.getConnectionInstance());
        }
    }

    public void process(ConnectionInstance<C> connectionInstance) {
        ConnectionPin<C> connectionPin;
        this.backingLock.readLock().lock();
        try {
            connectionPin = this.backingMap.get(connectionInstance);
        }
        finally {
            this.backingLock.readLock().unlock();
        }
        if (connectionPin != null) {
            connectionPin.free();
            if (connectionPin.isTerminated()) {
                this.terminate(connectionPin.getConnectionInstance());
            } else if (State.STARTED.equals((Object)this.stateRef.get())) {
                try {
                    this.freeQueue.put(connectionPin);
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(ConnectionPinManager.class).error((Throwable)interruptedException);
                }
            }
        }
    }

    public void terminate(ConnectionInstance<C> connectionInstance) {
        ConnectionPin<C> connectionPin;
        this.backingLock.writeLock().lock();
        try {
            connectionPin = this.backingMap.remove(connectionInstance);
        }
        finally {
            this.backingLock.writeLock().unlock();
        }
        if (connectionPin != null) {
            this.size.decrementAndGet();
            connectionPin.fizzle();
            try {
                connectionPin.getConnectionInstance().close();
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ConnectionPinManager.class).error((Throwable)exception);
            }
            try {
                ConnectionPin<C> replacementConnectionPin = this.addConnectionPin(false);
                if (replacementConnectionPin != null) {
                    this.freeQueue.put(replacementConnectionPin);
                }
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ConnectionPinManager.class).error((Throwable)exception);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void shutdown() throws ConnectionPoolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getPoolSize() {
        return this.size.get();
    }

    public int getFreeSize() {
        return this.freeQueue.size();
    }

    public int getProcessingSize() {
        return this.getPoolSize() - this.getFreeSize();
    }

    public StackTrace[] getExistentialStackTraces() {
        LinkedList<StackTrace> stackTraceList = new LinkedList<StackTrace>();
        this.backingLock.readLock().lock();
        try {
            for (ConnectionPin<C> connectionPin : this.backingMap.values()) {
                if (this.freeQueue.contains(connectionPin)) continue;
                stackTraceList.add(new StackTrace(connectionPin.getExistentialStackTrace()));
            }
        }
        finally {
            this.backingLock.readLock().unlock();
        }
        StackTrace[] stackTraces = new StackTrace[stackTraceList.size()];
        stackTraceList.toArray(stackTraces);
        return stackTraces;
    }

    private static enum State {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

