/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.quorum.pool.connection.ConnectionInstance;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.scribe.pen.LoggerManager;

public class ConnectionWorker<C>
implements Runnable {
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private final ConnectionPool<C> connectionPool;
    private final AtomicReference<State> stateRef = new AtomicReference();
    private ConnectionInstance<C> connectionInstance;
    private Exception exception;

    public ConnectionWorker(ConnectionPool<C> connectionPool) {
        this.connectionPool = connectionPool;
    }

    public ConnectionInstance<C> getConnectionInstance() {
        return this.connectionInstance;
    }

    public boolean abort() throws Exception {
        if (!this.stateRef.compareAndSet(null, State.ABORTED)) {
            this.terminationLatch.await();
            if (State.TERMINATED.equals((Object)this.stateRef.get())) {
                throw this.exception;
            }
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        try {
            try {
                this.connectionInstance = this.connectionPool.getConnectionInstanceFactory().createInstance(this.connectionPool);
                if (!this.stateRef.compareAndSet(null, State.COMPLETED) && this.connectionInstance != null) {
                    this.connectionInstance.close();
                }
            }
            catch (Exception exception) {
                if (!this.stateRef.compareAndSet(null, State.TERMINATED)) {
                    LoggerManager.getLogger(ConnectionWorker.class).error((Throwable)exception);
                } else {
                    this.exception = exception;
                }
                this.terminationLatch.countDown();
            }
        }
        finally {
            this.terminationLatch.countDown();
        }
    }

    private static enum State {
        COMPLETED,
        ABORTED,
        TERMINATED;

    }
}

